/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc.micronaut;

import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.BiFunction;
import net.javacrumbs.shedlock.provider.jdbc.internal.AbstractJdbcStorageAccessor;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class MicronautJdbcStorageAccessor
extends AbstractJdbcStorageAccessor {
    private final TransactionOperations<Connection> transactionManager;
    private final TransactionDefinition.Propagation propagation = TransactionDefinition.Propagation.REQUIRES_NEW;

    MicronautJdbcStorageAccessor(@NonNull TransactionOperations<Connection> transactionManager, @NonNull String tableName) {
        super(tableName);
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager can not be null");
    }

    protected <T> T executeCommand(String sql, AbstractJdbcStorageAccessor.SqlFunction<PreparedStatement, T> body, BiFunction<String, SQLException, T> exceptionHandler) {
        return (T)this.transactionManager.execute(TransactionDefinition.of((TransactionDefinition.Propagation)this.propagation), status -> {
            Object object;
            block8: {
                PreparedStatement statement = ((Connection)status.getConnection()).prepareStatement(sql);
                try {
                    object = body.apply((Object)statement);
                    if (statement == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        return exceptionHandler.apply(sql, e);
                    }
                }
                statement.close();
            }
            return object;
        });
    }
}

