/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.quarkus;

import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.datasource.keys.KeyCommands;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public class QuarkusRedisLockProvider
implements ExtensibleLockProvider {
    private static final String KEY_PREFIX_DEFAULT = "job-lock";
    private final RedisDataSource redisDataSource;
    private final KeyCommands<String> keyCommands;
    private final String keyPrefix;

    public QuarkusRedisLockProvider(RedisDataSource dataSource) {
        this(dataSource, KEY_PREFIX_DEFAULT);
    }

    public QuarkusRedisLockProvider(@NonNull RedisDataSource dataSource, @NonNull String keyPrefix) {
        this.keyPrefix = keyPrefix;
        this.redisDataSource = dataSource;
        this.keyCommands = dataSource.key(String.class);
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        long expireTime = QuarkusRedisLockProvider.getMillisUntil(lockConfiguration.getLockAtMostUntil());
        String key = this.buildKey(lockConfiguration.getName());
        Response response = this.redisDataSource.execute(Command.SET, new String[]{key, QuarkusRedisLockProvider.buildValue(), "NX", "PX", Long.toString(expireTime)});
        if (response != null && "OK".equals(response.toString())) {
            return Optional.of(new RedisLock(key, this, lockConfiguration));
        }
        return Optional.empty();
    }

    private Optional<SimpleLock> extend(LockConfiguration lockConfiguration) {
        long expireTime = QuarkusRedisLockProvider.getMillisUntil(lockConfiguration.getLockAtMostUntil());
        String key = this.buildKey(lockConfiguration.getName());
        boolean success = this.extendKeyExpiration(key, expireTime);
        if (success) {
            return Optional.of(new RedisLock(key, this, lockConfiguration));
        }
        return Optional.empty();
    }

    String buildKey(String lockName) {
        return this.keyPrefix + ":" + lockName;
    }

    private boolean extendKeyExpiration(String key, long expiration) {
        return this.keyCommands.pexpire((Object)key, expiration);
    }

    private void deleteKey(String key) {
        this.keyCommands.del((Object[])new String[]{key});
    }

    private static long getMillisUntil(Instant instant) {
        return Duration.between(ClockProvider.now(), instant).toMillis();
    }

    private static String buildValue() {
        return String.format("ADDED:%s@%s", Utils.toIsoString((Instant)ClockProvider.now()), Utils.getHostname());
    }

    private static final class RedisLock
    extends AbstractSimpleLock {
        private final String key;
        private final QuarkusRedisLockProvider quarkusLockProvider;

        private RedisLock(String key, QuarkusRedisLockProvider jedisLockProvider, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.quarkusLockProvider = jedisLockProvider;
        }

        public void doUnlock() {
            long keepLockFor = QuarkusRedisLockProvider.getMillisUntil(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor <= 0L) {
                try {
                    this.quarkusLockProvider.deleteKey(this.key);
                }
                catch (Exception e) {
                    throw new LockException("Can not remove key", (Throwable)e);
                }
            } else {
                this.quarkusLockProvider.extendKeyExpiration(this.key, keepLockFor);
            }
        }

        @NonNull
        protected Optional<SimpleLock> doExtend(@NonNull LockConfiguration newConfiguration) {
            return this.quarkusLockProvider.extend(newConfiguration);
        }
    }
}

