/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.spring;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class RedisLockProvider
implements LockProvider {
    private static final String KEY_PREFIX = "job-lock";
    private static final String ENV_DEFAULT = "default";
    private final ShedlockRedisTemplate redisTemplate;
    private final String environment;

    public RedisLockProvider(RedisConnectionFactory redisConn) {
        this(redisConn, ENV_DEFAULT);
    }

    public RedisLockProvider(RedisConnectionFactory redisConn, String environment) {
        this.redisTemplate = new ShedlockRedisTemplate(redisConn);
        this.environment = environment;
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        Expiration expiration;
        String key = RedisLockProvider.buildKey(lockConfiguration.getName(), this.environment);
        if (this.redisTemplate.tryToSetExpiration(key, expiration = RedisLockProvider.getExpiration(lockConfiguration.getLockAtMostUntil()), RedisStringCommands.SetOption.SET_IF_ABSENT).booleanValue()) {
            return Optional.of(new RedisLock(key, this.redisTemplate, lockConfiguration));
        }
        return Optional.empty();
    }

    private static Expiration getExpiration(Instant until) {
        return Expiration.from((long)RedisLockProvider.getMsUntil(until), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static long getMsUntil(Instant until) {
        return Duration.between(Instant.now(), until).toMillis();
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown host";
        }
    }

    static String buildKey(String lockName, String env) {
        return String.format("%s:%s:%s", KEY_PREFIX, env, lockName);
    }

    private static class ShedlockRedisTemplate
    extends StringRedisTemplate {
        private ShedlockRedisTemplate(RedisConnectionFactory connectionFactory) {
            super(connectionFactory);
        }

        private Boolean tryToSetExpiration(String key, Expiration expiration, RedisStringCommands.SetOption option) {
            return (Boolean)this.execute(connection -> connection.set(this.serialize(key), this.buildValue(), expiration, option), false);
        }

        private byte[] buildValue() {
            return this.serialize(String.format("ADDED:%s@%s", Instant.now().toString(), RedisLockProvider.getHostname()));
        }

        private byte[] serialize(String string) {
            return this.getStringSerializer().serialize((Object)string);
        }
    }

    private static final class RedisLock
    implements SimpleLock {
        private final String key;
        private final ShedlockRedisTemplate redisTemplate;
        private final LockConfiguration lockConfiguration;

        private RedisLock(String key, ShedlockRedisTemplate redisTemplate, LockConfiguration lockConfiguration) {
            this.key = key;
            this.redisTemplate = redisTemplate;
            this.lockConfiguration = lockConfiguration;
        }

        public void unlock() {
            Expiration keepLockFor = RedisLockProvider.getExpiration(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor.getExpirationTimeInMilliseconds() <= 0L) {
                try {
                    this.redisTemplate.delete(this.key);
                }
                catch (Exception e) {
                    throw new LockException("Can not remove node", (Throwable)e);
                }
            } else {
                this.redisTemplate.tryToSetExpiration(this.key, keepLockFor, RedisStringCommands.SetOption.SET_IF_PRESENT);
            }
        }
    }
}

