/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.time.Duration;
import net.javacrumbs.shedlock.core.LockProvider;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringValueResolver;

abstract class AbstractProxyScheduledLockAopBeanPostProcessor
extends AbstractBeanFactoryAwareAdvisingPostProcessor
implements BeanPostProcessor,
EmbeddedValueResolverAware {
    private final String defaultLockAtMostFor;
    private final String defaultLockAtLeastFor;
    private final LockProvider lockProvider;
    private StringValueResolver resolver;

    AbstractProxyScheduledLockAopBeanPostProcessor(String defaultLockAtMostFor, String defaultLockAtLeastFor, LockProvider lockProvider) {
        this.defaultLockAtMostFor = defaultLockAtMostFor;
        this.defaultLockAtLeastFor = defaultLockAtLeastFor;
        this.lockProvider = lockProvider;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        this.advisor = this.getAdvisor(this.lockProvider);
        return super.postProcessAfterInitialization(bean, beanName);
    }

    protected abstract AbstractPointcutAdvisor getAdvisor(LockProvider var1);

    protected Duration defaultLockAtLeastForDuration() {
        return this.toDuration(this.defaultLockAtLeastFor);
    }

    protected Duration defaultLockAtMostForDuration() {
        return this.toDuration(this.defaultLockAtMostFor);
    }

    protected StringValueResolver getResolver() {
        return this.resolver;
    }

    private Duration toDuration(String string) {
        return Duration.parse(this.resolver.resolveStringValue(string));
    }

    public LockProvider getLockProvider() {
        return this.lockProvider;
    }
}

