/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.encoder;

import net.jextra.tucker.encoder.Html4DecimalMap;
import net.jextra.tucker.encoder.Html4EntityMap;
import net.jextra.tucker.encoder.Html4HexMap;

public class Encoder {
    public static String encodeForHtml(String input) {
        if (input != null && !input.isEmpty()) {
            StringBuilder out = new StringBuilder();
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                String s = "" + c;
                if (Html4EntityMap.ESCAPE.containsKey(s)) {
                    out.append(Html4EntityMap.ESCAPE.get(s));
                    continue;
                }
                if (c >= '\u0080' && c < '\u00ff') {
                    String hexChars = "0123456789ABCDEF";
                    int a = c % 16;
                    int b = (c - a) / 16;
                    out.append("&#x").append(hexChars.charAt(b)).append(hexChars.charAt(a)).append(';');
                    continue;
                }
                out.append(c);
            }
            return out.toString();
        }
        return input;
    }

    public static String decodeForHtml(String input) {
        if (input != null && !input.isEmpty()) {
            CharSequence c;
            for (CharSequence entity : Html4EntityMap.UNESCAPE.keySet()) {
                if (!input.contains(entity)) continue;
                c = Html4EntityMap.UNESCAPE.get(entity);
                input = input.replace(entity, c);
            }
            for (CharSequence entity : Html4HexMap.UNESCAPE.keySet()) {
                if (!input.contains(entity)) continue;
                c = Html4HexMap.UNESCAPE.get(entity);
                input = input.replace(entity, c);
            }
            for (CharSequence entity : Html4DecimalMap.UNESCAPE.keySet()) {
                if (!input.contains(entity)) continue;
                c = Html4DecimalMap.UNESCAPE.get(entity);
                input = input.replace(entity, c);
            }
        }
        return input;
    }

    public static boolean test() {
        for (CharSequence c : Html4EntityMap.ESCAPE.keySet()) {
            String decode;
            CharSequence entity = Html4EntityMap.ESCAPE.get(c);
            CharSequence e = Html4EntityMap.UNESCAPE.get(entity);
            String encode = Encoder.encodeForHtml(c.toString());
            if (encode.equals(decode = Encoder.decodeForHtml(encode))) continue;
            return false;
        }
        return true;
    }
}

