/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.nipper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jextra.tucker.nipper.NLine;
import net.jextra.tucker.nipper.NPrinter;

public class NBlock {
    private List<NLine> lines = new ArrayList<NLine>();
    private Map<String, String> varValues = new LinkedHashMap<String, String>();

    public NBlock addBlock(NBlock other) {
        for (NLine line : other.lines) {
            this.lines.add(line);
        }
        for (String key : other.varValues.keySet()) {
            this.varValues.put(key, other.varValues.get(key));
        }
        return this;
    }

    public void addLine(NLine line) {
        this.lines.add(line);
    }

    public void setVariableValue(String name, String value) {
        this.varValues.put(name, value);
    }

    public Map<String, String> getVariableValues() {
        return this.varValues;
    }

    public List<NLine> getRoots() {
        ArrayList<NLine> roots = new ArrayList<NLine>();
        for (NLine line : this.lines) {
            if (line.getParent() != null) continue;
            roots.add(line);
        }
        return roots;
    }

    public String substituteVariables(String string) {
        ArrayList<Fragment> frags = new ArrayList<Fragment>();
        frags.add(new Fragment(string));
        for (String key : this.varValues.keySet()) {
            for (int s = 0; s < 2; ++s) {
                String name = s == 0 ? "$" + key : "$(" + key + ")";
                String value = this.varValues.get(key);
                ArrayList<Fragment> newFrags = new ArrayList<Fragment>();
                for (Fragment f : frags) {
                    if (f.getValue() != null) {
                        newFrags.add(f);
                        continue;
                    }
                    newFrags.addAll(this.fragment(f.getText(), name, value));
                }
                frags = newFrags;
            }
        }
        StringBuilder builder = new StringBuilder();
        for (Fragment f : frags) {
            builder.append(f.toString());
        }
        return builder.toString();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        NPrinter printer = new NPrinter(writer);
        printer.print(this);
        writer.close();
        return stringWriter.toString();
    }

    private List<Fragment> fragment(String string, String key, String value) {
        ArrayList<Fragment> frags = new ArrayList<Fragment>();
        int i = string.indexOf(key);
        if (i < 0) {
            frags.add(new Fragment(string));
            return frags;
        }
        int afterI = i + key.length();
        if (afterI >= string.length()) {
            if (i > 0) {
                frags.add(new Fragment(string.substring(0, i)));
            }
            frags.add(new Fragment(string.substring(i, afterI), value));
        } else if (afterI >= string.length() || string.charAt(afterI) == ' ') {
            if (i > 0) {
                frags.add(new Fragment(string.substring(0, i)));
            }
            frags.add(new Fragment(string.substring(i, afterI), value));
            frags.addAll(this.fragment(string.substring(afterI), key, value));
        } else {
            frags.add(new Fragment(string));
        }
        return frags;
    }

    private static class Fragment {
        private String text;
        private String value;

        public Fragment(String text) {
            this.text = text;
        }

        public Fragment(String text, String value) {
            this.text = text;
            this.value = value;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value == null ? this.text : this.value;
        }
    }
}

