/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.nipper;

import java.util.ArrayList;
import java.util.List;

public class NLine {
    private Type type;
    private NLine parent;
    private int row;
    private int spaces;
    private int indent;
    private String content;
    private String name;
    private String value;
    private String comment;
    private ArrayList<NLine> children;

    public NLine(int row, int spaces, String content, String comment) {
        this.row = row;
        this.spaces = spaces;
        this.content = content;
        this.comment = comment;
        this.children = new ArrayList();
    }

    public NLine getParent() {
        return this.parent;
    }

    public void addChild(NLine child) {
        this.children.add(child);
        child.parent = this;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<NLine> getChildren() {
        return this.children;
    }

    public List<NLine> getChildren(Type type) {
        ArrayList<NLine> list = new ArrayList<NLine>();
        for (NLine line : this.children) {
            if (line.getType() != type) continue;
            list.add(line);
        }
        return list;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getSpaces() {
        return this.spaces;
    }

    public void setSpaces(int spaces) {
        this.spaces = spaces;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        String p = String.format("%3d:-  ", this.row);
        if (this.parent != null) {
            p = String.format("%3d:%-3d", this.row, this.parent.getRow());
        }
        StringBuilder gap = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            gap.append("    ");
        }
        if (this.comment != null) {
            return String.format("%s %-12s %s%s[%s] %s", new Object[]{p, this.type, gap, this.content, this.comment, this.name});
        }
        return String.format("%s %-12s %s%s %s", new Object[]{p, this.type, gap, this.content, this.name});
    }

    public static enum Type {
        comment,
        include,
        variableDeclaration,
        atRule,
        selector,
        property,
        continuation;

    }
}

