/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.nipper;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.jextra.tucker.nipper.NBlock;
import net.jextra.tucker.nipper.NLine;

public class NPrinter {
    private PrintWriter out;
    private OutputParams p;
    private NBlock model;

    public NPrinter(PrintWriter out, OutputParams params) {
        this.out = out;
        this.p = params;
    }

    public NPrinter(PrintWriter out) {
        this(out, new OutputParams());
    }

    public void print(NBlock model) {
        this.model = model;
        this.printLines(0, model.getRoots());
    }

    private void printLines(int indent, List<NLine> list) {
        for (NLine line : list) {
            switch (line.getType()) {
                case atRule: {
                    if (line.hasChildren()) {
                        this.printIndent(indent);
                        this.printValue(line.getContent());
                        this.print(this.p.parentStart);
                        this.printCr();
                        this.printLines(indent + 1, line.getChildren());
                        this.printIndent(indent);
                        this.print(this.p.parentEnd);
                        this.printCr();
                        if (indent != 0) break;
                        this.printCr();
                        break;
                    }
                    this.printIndent(indent);
                    this.printValue(line.getContent());
                    if (!line.getContent().trim().endsWith("}")) {
                        this.print(this.p.propEnd);
                    }
                    this.printCr();
                    this.printCr();
                    break;
                }
                case selector: {
                    List<NLine> subs;
                    List<NLine> props = line.getChildren(NLine.Type.property);
                    if (!props.isEmpty()) {
                        for (String fullSelector : this.expandSelector(line)) {
                            this.printIndent(indent);
                            this.print(fullSelector);
                            this.print(this.p.parentStart);
                            this.printCr();
                            this.printLines(indent + 1, props);
                            this.printIndent(indent);
                            this.print(this.p.parentEnd);
                            this.printCr();
                            if (indent != 0) continue;
                            this.printCr();
                        }
                    }
                    if ((subs = line.getChildren(NLine.Type.selector)).isEmpty()) break;
                    this.printLines(indent, subs);
                    break;
                }
                case property: {
                    this.printIndent(indent);
                    this.print(line.getName() + this.p.propOp);
                    this.printValue(line.getValue());
                    List<NLine> continuations = line.getChildren(NLine.Type.continuation);
                    if (!continuations.isEmpty()) {
                        this.printCr();
                        boolean hasPrior = false;
                        for (NLine cLine : continuations) {
                            if (hasPrior) {
                                this.printCr();
                            }
                            this.printIndent(indent + 1);
                            this.print(cLine.getContent());
                            hasPrior = true;
                        }
                    }
                    this.print(this.p.propEnd);
                    this.printCr();
                    break;
                }
                case continuation: {
                    this.printIndent(indent);
                    this.printValue(line.getContent());
                    this.printCr();
                    this.printLines(indent, line.getChildren(NLine.Type.continuation));
                }
            }
        }
    }

    private void printIndent(int indent) {
        if (this.p.indent == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            this.out.print(this.p.indent);
        }
    }

    private void printCr() {
        if (this.p.useReturns) {
            this.out.println();
        }
    }

    private void print(String string) {
        this.out.print(string);
    }

    private void printValue(String string) {
        if (string == null) {
            return;
        }
        this.out.print(this.model.substituteVariables(string));
    }

    private List<String> expandSelector(NLine line) {
        if (line.getType() != NLine.Type.selector) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("");
            return list;
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        if (line.getParent() != null) {
            List<String> parentList = this.expandSelector(line.getParent());
            for (String string : parentList) {
                prefixes.add(string);
            }
        } else {
            prefixes.add("");
        }
        ArrayList<String> selectors = new ArrayList<String>();
        for (String prefix : prefixes) {
            for (String suffix : this.splitSelector(line.getContent())) {
                StringBuilder builder = new StringBuilder();
                builder.append(prefix);
                if (prefix.length() > 0 && !line.getContent().startsWith(":")) {
                    builder.append(" ");
                }
                builder.append(suffix);
                selectors.add(builder.toString());
            }
        }
        return selectors;
    }

    private List<String> splitSelector(String string) {
        ArrayList<String> list = new ArrayList<String>();
        for (String v : string.split(",")) {
            list.add(v.trim());
        }
        return list;
    }

    public static class OutputParams {
        public boolean useReturns = true;
        public String indent = "    ";
        public String parentStart = " {";
        public String parentEnd = "}";
        public String propOp = ": ";
        public String propEnd = ";";
    }
}

