/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.nipper;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import net.jextra.tucker.nipper.NBlock;
import net.jextra.tucker.nipper.NLine;
import net.jextra.tucker.nipper.ReaderProvider;

public class NReader {
    private BufferedReader reader;
    private ReaderProvider includeProvider;
    private NBlock model;

    public NReader(BufferedReader reader, ReaderProvider includeProvider) {
        this.reader = reader;
        this.includeProvider = includeProvider;
    }

    public NBlock parse() throws IOException {
        this.model = new NBlock();
        int row = 0;
        ArrayList<NLine> lines = new ArrayList<NLine>();
        String string = this.reader.readLine();
        while (string != null) {
            int i;
            for (i = 0; i < string.length() && (string.charAt(i) == ' ' || string.charAt(i) == '\t'); ++i) {
            }
            if (i < string.length()) {
                if ((string = string.substring(i)).startsWith("//")) {
                    NLine line = new NLine(row, i, null, string);
                    lines.add(line);
                } else {
                    Object comment = null;
                    int c = string.indexOf("//");
                    if (c >= 0) {
                        comment = string.substring(c + 2).trim();
                        string = string.substring(0, c).trim();
                    }
                    NLine line = new NLine(row, i, string, (String)comment);
                    lines.add(line);
                }
            }
            string = this.reader.readLine();
            ++row;
        }
        Stack<NLine> stack = new Stack<NLine>();
        int indent = 0;
        for (NLine line : lines) {
            if (stack.isEmpty()) {
                stack.push(line);
            } else if (line.getSpaces() < ((NLine)stack.peek()).getSpaces()) {
                while (!stack.isEmpty() && line.getSpaces() < ((NLine)stack.peek()).getSpaces()) {
                    stack.pop();
                    --indent;
                }
            } else if (line.getSpaces() > ((NLine)stack.peek()).getSpaces()) {
                ++indent;
                stack.push(line);
            }
            line.setIndent(indent);
        }
        HashMap<Integer, NLine> parents = new HashMap<Integer, NLine>();
        for (NLine line : lines) {
            NLine parent;
            if (line.getContent() == null || line.getContent().isEmpty()) {
                line.setType(NLine.Type.comment);
                continue;
            }
            if (line.getContent().startsWith("$")) {
                line.setType(NLine.Type.variableDeclaration);
                this.parseVar(line);
                continue;
            }
            if (line.getContent().toLowerCase().startsWith("%include")) {
                line.setType(NLine.Type.include);
                this.parseInclude(line);
                continue;
            }
            NLine nLine = parent = line.getIndent() == 0 ? null : (NLine)parents.get(line.getIndent() - 1);
            if (parent != null) {
                while (parent != null && parent.getType() == NLine.Type.continuation) {
                    parent = parent.getParent();
                }
                if (parent.getType() == NLine.Type.property && !parent.getContent().endsWith(":")) {
                    parent.setType(NLine.Type.selector);
                }
                parent.addChild(line);
            }
            if (line.getContent().startsWith("@")) {
                line.setType(NLine.Type.atRule);
            } else if (parent == null) {
                line.setType(NLine.Type.selector);
            } else {
                line.setType(parent.getType() == NLine.Type.property ? NLine.Type.continuation : NLine.Type.property);
                this.parseProperty(line);
            }
            parents.put(line.getIndent(), line);
        }
        for (NLine line : lines) {
            switch (line.getType()) {
                case include: {
                    NBlock child = this.readInclude(line.getValue());
                    if (child == null) break;
                    this.model.addBlock(child);
                    break;
                }
                case atRule: 
                case selector: 
                case property: 
                case continuation: {
                    this.model.addLine(line);
                }
            }
        }
        this.reader.close();
        return this.model;
    }

    private void parseVar(NLine line) {
        int colon = line.getContent().indexOf(58);
        if (colon >= 0) {
            line.setName(line.getContent().substring(1, colon).trim());
            line.setValue(line.getContent().substring(colon + 1).trim());
            this.model.setVariableValue(line.getName(), line.getValue());
        } else {
            line.setName(line.getContent().substring(1).trim());
            this.model.setVariableValue(line.getName(), "");
        }
    }

    private void parseInclude(NLine line) {
        int colon = line.getContent().indexOf(32);
        if (colon >= 0) {
            line.setName(line.getContent().substring(1, colon).trim());
            line.setValue(line.getContent().substring(colon + 1).trim());
        } else {
            line.setName(line.getContent().substring(1).trim());
        }
    }

    private void parseProperty(NLine line) {
        int colon = line.getContent().indexOf(58);
        if (colon >= 0) {
            line.setName(line.getContent().substring(0, colon).trim());
            String value = line.getContent().substring(colon + 1).trim();
            if (value.endsWith(";")) {
                value = value.substring(0, value.length() - 1);
            }
            line.setValue(value);
        } else {
            line.setName(line.getContent().trim());
        }
    }

    private NBlock readInclude(String name) throws IOException {
        if (this.includeProvider == null || name == null || name.trim().isEmpty()) {
            return null;
        }
        BufferedReader in = this.includeProvider.findReader(name.trim());
        if (in == null) {
            return null;
        }
        NReader reader = new NReader(in, this.includeProvider);
        NBlock block = reader.parse();
        in.close();
        return block;
    }
}

