/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.nipper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import net.jextra.tucker.nipper.NBlock;
import net.jextra.tucker.nipper.NReader;
import net.jextra.tucker.nipper.ReaderProvider;

public class Nipper {
    private ReaderProvider readerProvider;
    private NBlock model;

    public NBlock getBlock() {
        return this.model;
    }

    public Nipper setReaderProvider(ReaderProvider provider) {
        this.readerProvider = provider;
        return this;
    }

    public NBlock parse(Path path) throws IOException {
        BufferedReader in = Files.newBufferedReader(path);
        NBlock model = this.parse(in);
        in.close();
        return model;
    }

    public NBlock parse(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        this.parse(in);
        in.close();
        return this.model;
    }

    public NBlock parse(InputStream inputStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        NBlock model = this.parse(in);
        in.close();
        return model;
    }

    public NBlock parse(URL asset) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(asset.openStream()));
        NBlock model = this.parse(in);
        in.close();
        return model;
    }

    public NBlock parse(BufferedReader in) throws IOException {
        NReader reader = new NReader(in, this.readerProvider);
        this.model = reader.parse();
        return this.model;
    }
}

