/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.tucker;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import net.jextra.tucker.tucker.Hook;
import net.jextra.tucker.tucker.Node;
import net.jextra.tucker.tucker.NodeWriter;
import net.jextra.tucker.tucker.OutputContext;
import net.jextra.tucker.tucker.PageContext;
import net.jextra.tucker.tucker.Scope;

public class Block
extends Node {
    private Scope scope;
    private NodeWriter writer;

    public Block() {
        super(Node.NodeType.block);
        this.scope = new Scope();
        this.writer = new NodeWriter();
    }

    public Block(String name) {
        this();
        this.setTagName(name);
    }

    public Block(Block other) {
        super(other);
        this.scope = new Scope(other.scope);
        this.writer = new NodeWriter(other.writer);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public NodeWriter getWriter() {
        return this.writer;
    }

    public void setWriter(NodeWriter writer) {
        this.writer = writer;
    }

    public Set<String> getVariableNames() {
        return this.scope.getVariableNames();
    }

    public String getVariable(String name) {
        return this.scope.getVariable(name);
    }

    public Block setVariable(String name, String value) {
        return this.setVariable(name, value, true);
    }

    public Block setVariable(String name, String ... values) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String v : values) {
            if (v == null) continue;
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(v);
            ++count;
        }
        return this.setVariable(name, count > 0 ? builder.toString() : null);
    }

    public Block setVariable(String name, Collection<String> values) {
        if (values == null) {
            return this.setVariable(name, (String)null);
        }
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String v : values) {
            if (v == null) continue;
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(v);
            ++count;
        }
        return this.setVariable(name, count > 0 ? builder.toString() : null);
    }

    public Block setVariable(String name, String value, Boolean encode) {
        this.scope.setVariable(name, value, encode);
        return this;
    }

    public Block setBoolean(String name) {
        return this.setBoolean(name, true);
    }

    public Block clearBoolean(String name) {
        this.scope.clearBoolean(name);
        return this;
    }

    public Block setBoolean(String name, boolean value) {
        this.scope.setBoolean(name, value);
        return this;
    }

    public boolean getBoolean(String name) {
        return this.scope.getBoolean(name);
    }

    @Override
    public Node findByStyleClass(String clss) {
        for (Node node : this.getChildren()) {
            if (node.getNodeType() != Node.NodeType.tag) continue;
            if (node.hasStyleClass(clss)) {
                return node;
            }
            Node child = node.findByStyleClass(clss);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public void bind(String tag, Hook hook) {
        this.scope.bind(tag, hook);
    }

    public <T extends Hook> T bind(String tag, Class<T> elementClass) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.scope.bind(tag, elementClass);
    }

    public String render(PageContext page) {
        return this.render(page, this.getIndent());
    }

    public String render(PageContext page, int indent) {
        this.writer.setPageContext(page);
        this.writer.setIndent(indent);
        return this.writer.render(this);
    }

    @Deprecated
    public void write(OutputContext ctx, boolean inline) {
        ctx.write(this);
    }

    public String toString() {
        return this.render(new NodeWriter.PageContextStub());
    }

    private Node findByElementId(Node node, String id) {
        if (id.equals(node.getId())) {
            return node;
        }
        for (Node child : node.getChildren()) {
            Node e = this.findByElementId(child, id);
            if (e == null) continue;
            return e;
        }
        return null;
    }
}

