/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.tucker;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.jextra.tucker.tucker.Hook;
import net.jextra.tucker.tucker.Node;

class HookBinding {
    private String tagName;
    private String id;
    private Set<String> styleClasses = new HashSet<String>();
    private Hook hook;

    public HookBinding() {
    }

    public HookBinding(String hookSelector, Hook hook) {
        this();
        this.parseSelector(hookSelector);
        this.hook = hook;
    }

    public HookBinding(HookBinding other) {
        this();
        this.tagName = other.tagName;
        this.id = other.id;
        for (String clss : other.styleClasses) {
            this.styleClasses.add(clss);
        }
        this.hook = other.hook;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<String> getStyleClasses() {
        return this.styleClasses;
    }

    public void addStyleClass(String clss) {
        this.styleClasses.add(clss);
    }

    public boolean matches(String hookSelector) {
        HookBinding test = new HookBinding();
        test.parseSelector(hookSelector);
        return this.matches(test.getTagName(), test.getId(), test.getStyleClasses());
    }

    public boolean matches(Node node) {
        return this.matches(node.getTagName(), node.getId(), node.getStyleClasses());
    }

    public boolean matches(String testTagName, String testId, Collection<String> testStyleClasses) {
        if (!testTagName.equals(this.tagName)) {
            return false;
        }
        if (this.id != null && !testId.equals(this.id)) {
            return false;
        }
        for (String clss : this.styleClasses) {
            if (testStyleClasses.contains(clss)) continue;
            return false;
        }
        return true;
    }

    public Hook getHook() {
        return this.hook;
    }

    public void setHook(Hook hook) {
        this.hook = hook;
    }

    private void parseSelector(String string) {
        string = string.trim();
        StringBuilder tagName = new StringBuilder();
        StringBuilder id = new StringBuilder();
        StringBuilder className = new StringBuilder();
        int state = 0;
        block9: for (int pos = 0; pos < string.length(); ++pos) {
            char c = string.charAt(pos);
            switch (c) {
                case '#': {
                    state = 1;
                    continue block9;
                }
                case '.': {
                    state = 2;
                    if (className.length() <= 0) continue block9;
                    this.addStyleClass(className.toString());
                    className = new StringBuilder();
                    continue block9;
                }
                default: {
                    switch (state) {
                        case 0: {
                            tagName.append(c);
                            continue block9;
                        }
                        case 1: {
                            id.append(c);
                            continue block9;
                        }
                        case 2: {
                            className.append(c);
                        }
                    }
                }
            }
        }
        this.setTagName(tagName.toString());
        if (id.length() > 0) {
            this.setId(id.toString());
        }
        if (className.length() > 0) {
            this.addStyleClass(className.toString());
        }
    }
}

