/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.tucker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jextra.tucker.tucker.Attribute;
import net.jextra.tucker.tucker.Segment;

public class Node {
    public static final String DEFAULT_TAG = "div";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    private NodeType type = NodeType.tag;
    private int indent;
    private int row;
    private boolean inline;
    private String tagName = "div";
    private Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
    private List<Segment> segments = new ArrayList<Segment>();
    private List<Node> children = new ArrayList<Node>();
    private String rawText;

    public Node() {
    }

    public Node(NodeType type) {
        this();
        this.type = type;
    }

    public Node(Node other) {
        this();
        this.type = other.type;
        this.indent = other.indent;
        this.row = other.row;
        this.inline = other.inline;
        this.tagName = other.tagName;
        this.rawText = other.rawText;
        for (String key : other.attributes.keySet()) {
            Attribute att = other.attributes.get(key);
            Attribute newAtt = new Attribute(att);
            this.attributes.put(key, newAtt);
        }
        for (Segment segment : other.segments) {
            this.segments.add(new Segment(segment));
        }
        for (Node child : other.children) {
            this.children.add(new Node(child));
        }
    }

    public static Node newRawNode(String rawText) {
        Node node = new Node(NodeType.rawText);
        node.setRawText(rawText);
        return node;
    }

    public NodeType getType() {
        return this.type;
    }

    public Node setType(NodeType type) {
        this.type = type;
        return this;
    }

    public NodeType getNodeType() {
        return this.type;
    }

    public Node setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public int getIndent() {
        return this.indent;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String key) {
        this.addAttribute(key, null);
    }

    public void addAttribute(String key, String value) {
        if (this.attributes.containsKey(key)) {
            Attribute att = this.attributes.get(key);
            if (att == null || att.getValue() == null || att.getValue().isEmpty()) {
                this.attributes.put(key, att);
            } else {
                att.setValue(att.getValue() + " " + value);
            }
        } else {
            Attribute att = new Attribute(key, value);
            this.attributes.put(key, att);
        }
    }

    public void addAttribute(Attribute att) {
        if (att == null) {
            return;
        }
        this.attributes.put(att.getKey(), att);
    }

    public Attribute getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Attribute removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public void setAttribute(String key, String value) {
        this.removeAttribute(key);
        this.addAttribute(key, value);
    }

    public String getId() {
        Attribute att = this.attributes.get(ATT_ID);
        return att == null ? null : att.getValue();
    }

    public Node findByElementId(String id) {
        if (this.getId() != null && this.getId().equals(id)) {
            return this;
        }
        for (Node child : this.getChildren()) {
            Node foundNode = child.findByElementId(id);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public Set<String> getStyleClasses() {
        HashSet<String> set = new HashSet<String>();
        Attribute att = this.attributes.get(ATT_CLASS);
        if (att == null) {
            return set;
        }
        for (String string : att.getValue().split("\\s")) {
            set.add(string);
        }
        return set;
    }

    public boolean hasStyleClass(String clss) {
        Attribute att = this.attributes.get(ATT_CLASS);
        if (att == null) {
            return false;
        }
        for (String string : att.getValue().split("\\s")) {
            if (!clss.equals(string)) continue;
            return true;
        }
        return false;
    }

    public Node findByStyleClass(String clss) {
        if (this.hasStyleClass(clss)) {
            return this;
        }
        for (Node child : this.getChildren()) {
            Node foundNode = child.findByStyleClass(clss);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public void addSegment(Segment segment) {
        this.segments.add(segment);
    }

    public void addText(String text) {
        this.segments.add(new Segment(text));
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void addChild(Node node) {
        this.children.add(node);
    }

    public int insert(String insertionName, Node insertNode) {
        int count = 0;
        if (this.type == NodeType.insertion && insertionName.equals(this.tagName)) {
            this.addChild(insertNode);
            ++count;
        }
        if (count == 0) {
            for (Node node : this.getChildren()) {
                count += node.insert(insertionName, insertNode);
            }
        }
        return count;
    }

    public int insert(String insertionName, String text) {
        Node rawNode = new Node(NodeType.rawText);
        rawNode.setRawText(text);
        return this.insert(insertionName, rawNode);
    }

    public String getRawText() {
        return this.rawText;
    }

    public Node setRawText(String rawText) {
        this.rawText = rawText;
        return this;
    }

    public static enum NodeType {
        block,
        insertion,
        tag,
        rawText;

    }
}

