/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.tucker;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jextra.tucker.tucker.Attribute;
import net.jextra.tucker.tucker.Block;
import net.jextra.tucker.tucker.Hook;
import net.jextra.tucker.tucker.HookContext;
import net.jextra.tucker.tucker.Node;
import net.jextra.tucker.tucker.PageContext;
import net.jextra.tucker.tucker.Scope;
import net.jextra.tucker.tucker.ScopeContext;
import net.jextra.tucker.tucker.Segment;
import net.jextra.tucker.tucker.Translator;

public class NodeWriter {
    private PageContext pageContext;
    private ScopeContext scopeContext;
    private Translator translator;
    private PrintWriter out;

    public NodeWriter() {
        this.scopeContext = new ScopeContext();
    }

    public NodeWriter(NodeWriter other) {
        this.pageContext = other.pageContext;
        this.scopeContext = new ScopeContext(other.scopeContext);
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    public ScopeContext getScopeContext() {
        return this.scopeContext;
    }

    public void setScopeContext(ScopeContext scopeContext) {
        this.scopeContext = scopeContext;
    }

    public int getIndent() {
        return this.scopeContext.getIndent();
    }

    public NodeWriter setIndent(int indent) {
        this.scopeContext.setIndent(indent);
        return this;
    }

    public String render(Node node) {
        List<Node> hardNodes = this.hardenNode(node);
        StringWriter stringWriter = new StringWriter();
        this.out = new PrintWriter(stringWriter);
        for (Node n : hardNodes) {
            this.writeNode(n);
        }
        this.out.close();
        return stringWriter.toString();
    }

    public void writeIndent() {
        this.out.print(this.scopeContext.getIndentWhitespace());
    }

    public void writeIndent(int d) {
        for (int i = 0; i < d; ++i) {
            this.out.print("  ");
        }
    }

    public void writeString(String value) {
        String string = this.cleanString(value);
        if (string != null) {
            this.out.write(string);
        }
    }

    public String cleanString(String value) {
        if (value == null) {
            return null;
        }
        value = ((String)value).replace('\u0001', '{');
        value = ((String)value).replace('\u0002', '}');
        value = ((String)value).replace('\u0003', '`');
        value = ((String)value).replace("<", "&lt;");
        value = ((String)value).replace(">", "&gt;");
        int varReplacedCount = 0;
        int varNotSetCount = 0;
        Pattern varPattern = Pattern.compile("([^\u0004]*)\u0004([^\u0005]*)\u0005(.*)");
        Matcher m = varPattern.matcher((CharSequence)value);
        while (m.matches()) {
            String var = m.group(2);
            String varValue = this.getVariable(var);
            if (varValue != null) {
                ++varReplacedCount;
                value = m.group(1) + varValue + m.group(3);
            } else {
                ++varNotSetCount;
                value = m.group(1) + m.group(3);
            }
            m = varPattern.matcher((CharSequence)value);
        }
        Pattern boolPattern = Pattern.compile("([^\u001c]*)\u001c([^\u001d]*)\u001d(.*)");
        Matcher m2 = boolPattern.matcher((CharSequence)value);
        while (m2.matches()) {
            String var = m2.group(2);
            boolean boolValue = this.getBoolean(var);
            if (boolValue) {
                ++varReplacedCount;
                value = m2.group(1) + var + m2.group(3);
            } else {
                ++varNotSetCount;
                value = m2.group(1) + m2.group(3);
            }
            m2 = boolPattern.matcher((CharSequence)value);
        }
        if (this.translator != null) {
            Pattern phrasePattern = Pattern.compile("([^\u0006]*)\u0006([^\u0007]*)\u0007(.*)");
            Matcher m3 = phrasePattern.matcher((CharSequence)value);
            while (m3.matches()) {
                value = m3.group(1) + this.translate(m3.group(2)) + m3.group(3);
                m3 = phrasePattern.matcher((CharSequence)value);
            }
        }
        value = ((String)value).replaceAll("\u0006", "");
        value = ((String)value).replaceAll("\u0007", "");
        if (varReplacedCount == 0 && varNotSetCount == 1 && ((String)value).trim().isEmpty()) {
            return null;
        }
        return value;
    }

    public void printNode(Node node, int depth) {
        if (node == null) {
            return;
        }
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            prefix.append(".   ");
        }
        StringBuilder atts = new StringBuilder();
        for (String key : node.getAttributes().keySet()) {
            Attribute att = node.getAttribute(key);
            atts.append(String.format(" %s=\"%s\"", key, att == null ? "null" : att.getValue()));
        }
        for (Node child : node.getChildren()) {
            this.printNode(child, depth + 1);
        }
    }

    protected String translate(String sourceString) {
        if (sourceString == null || this.translator == null) {
            return sourceString;
        }
        try {
            String targetString = this.translator.translate(sourceString);
            return targetString == null ? sourceString : targetString;
        }
        catch (Exception e) {
            return sourceString;
        }
    }

    private List<Node> hardenNode(Node node) {
        ArrayList<Node> list = new ArrayList<Node>();
        switch (node.getNodeType()) {
            case block: {
                Block block = (Block)node;
                this.scopeContext.push(block.getScope());
                Block hardNode = this.hardenBlock(block);
                for (Node hardChild : this.hardenChildren(node)) {
                    hardNode.addChild(hardChild);
                }
                list.add(hardNode);
                this.scopeContext.pop();
                break;
            }
            case tag: {
                Node hardNode = this.hardenTagNode(node);
                for (Node hardChild : this.hardenChildren(node)) {
                    hardNode.addChild(hardChild);
                }
                Hook hook = this.scopeContext.findHook(hardNode);
                if (hook != null) {
                    List<Node> hardNodes;
                    Node newNode = this.performHook(hook, hardNode);
                    if (newNode == null || (hardNodes = this.hardenNode(newNode)) == null) break;
                    for (Node n : hardNodes) {
                        list.add(n);
                    }
                    break;
                }
                list.add(hardNode);
                break;
            }
            case insertion: {
                for (Node hardChild : this.hardenChildren(node)) {
                    list.add(hardChild);
                }
                break;
            }
            case rawText: {
                Node hardNode = new Node(Node.NodeType.rawText);
                hardNode.setRawText(node.getRawText());
                list.add(hardNode);
                break;
            }
        }
        return list;
    }

    private List<Node> hardenChildren(Node parent) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node child : parent.getChildren()) {
            List<Node> outcome = this.hardenNode(child);
            if (outcome == null || outcome.isEmpty()) continue;
            list.addAll(outcome);
        }
        return list;
    }

    private Block hardenBlock(Block src) {
        Block hardNode = new Block();
        hardNode.setTagName(src.getTagName());
        hardNode.setScope(new Scope(src.getScope()));
        for (Attribute att : src.getAttributes().values()) {
            hardNode.addAttribute(this.hardenAttributes(att));
        }
        return hardNode;
    }

    private Node hardenTagNode(Node src) {
        Node hardNode = new Node(Node.NodeType.tag);
        hardNode.setTagName(src.getTagName());
        hardNode.setInline(src.isInline());
        for (Attribute att : src.getAttributes().values()) {
            hardNode.addAttribute(this.hardenAttributes(att));
        }
        for (Segment seg : src.getSegments()) {
            Segment hardSeg = this.hardenSegment(seg);
            if (hardSeg == null) continue;
            hardNode.addSegment(hardSeg);
        }
        return hardNode;
    }

    private Attribute hardenAttributes(Attribute att) {
        if (att == null) {
            return null;
        }
        String key = this.cleanString(att.getKey());
        if (key == null || key.trim().isEmpty()) {
            return null;
        }
        if (att.getValue() == null) {
            Attribute newAtt = new Attribute(key, null);
            return newAtt;
        }
        String value = this.cleanString(att.getValue());
        if (value == null) {
            return null;
        }
        return new Attribute(key, value);
    }

    private Segment hardenSegment(Segment seg) {
        switch (seg.getType()) {
            case text: {
                return new Segment(this.cleanString(seg.getValue()));
            }
            case inline: {
                List<Node> nodes = this.hardenNode(seg.getNode());
                if (nodes.isEmpty()) break;
                Segment hardSeg = new Segment(Segment.Type.inline);
                hardSeg.setNode(nodes.get(0));
                return hardSeg;
            }
        }
        return null;
    }

    private void writeNode(Node node) {
        switch (node.getNodeType()) {
            case block: {
                Block block = (Block)node;
                this.scopeContext.push(block.getScope());
                this.writeChildren(node, this.getIndent());
                this.scopeContext.pop();
                break;
            }
            case tag: {
                int childCount;
                this.writeTagStart(node);
                this.writeSegments(node);
                if (!node.getChildren().isEmpty()) {
                    this.out.println();
                }
                this.writeTagEnd(node, (childCount = this.writeChildren(node, this.getIndent() + 1)) > 0);
                break;
            }
            case insertion: {
                this.writeChildren(node, this.getIndent());
                break;
            }
            case rawText: {
                this.writeIndent();
                this.out.write(node.getRawText());
                this.out.println();
            }
        }
    }

    private void writeTagStart(Node node) {
        if (!node.isInline()) {
            this.writeIndent();
        }
        this.out.write(60);
        this.writeString(node.getTagName());
        if (node.getAttribute("id") != null) {
            this.writeAttribute(node.getAttribute("id"));
        }
        if (node.getAttribute("class") != null) {
            this.writeAttribute(node.getAttribute("class"));
        }
        for (Attribute att : node.getAttributes().values()) {
            if ("id".equals(att.getKey()) || "class".equals(att.getKey())) continue;
            this.writeAttribute(att);
        }
        this.out.write(">");
    }

    private void writeAttribute(Attribute att) {
        if (att == null) {
            return;
        }
        String key = this.cleanString(att.getKey());
        if (key == null || key.trim().isEmpty()) {
            return;
        }
        if (att.getValue() == null) {
            this.out.print(" ");
            this.writeString(key);
        } else {
            String value = this.cleanString(att.getValue());
            if (value != null) {
                this.out.print(" ");
                this.writeString(key);
                this.out.print("=\"");
                this.writeString(value);
                this.out.print("\"");
            }
        }
    }

    private void writeSegments(Node node) {
        for (Segment segment : node.getSegments()) {
            switch (segment.getType()) {
                case text: {
                    this.writeString(segment.getValue());
                    break;
                }
                case inline: {
                    this.writeNode(segment.getNode());
                }
            }
        }
    }

    private int writeChildren(Node node, int childIndent) {
        int childCount = 0;
        for (Node child : node.getChildren()) {
            int oldIndex = this.scopeContext.getIndent();
            this.scopeContext.setIndent(childIndent);
            this.writeNode(child);
            ++childCount;
            this.scopeContext.setIndent(oldIndex);
        }
        return childCount;
    }

    private void writeTagEnd(Node node, boolean hasChildren) {
        if (!node.isInline() && hasChildren) {
            this.writeIndent();
        }
        this.out.write("</");
        this.writeString(node.getTagName());
        this.out.write(">");
        if (!node.isInline()) {
            this.out.println();
        }
    }

    private String getVariable(String name) {
        return this.scopeContext.getVariable(name);
    }

    private boolean getBoolean(String name) {
        return this.scopeContext.getBoolean(name);
    }

    private Node performHook(Hook hook, Node node) {
        try {
            HookContext ctx = new HookContext(this.pageContext, this.scopeContext, node);
            Node newNode = hook.doHook(ctx);
            return newNode == null ? node : newNode;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class PageContextStub
    implements PageContext {
        @Override
        public boolean addStyleSheet(String url, boolean inline) throws Exception {
            return true;
        }

        @Override
        public void addFont(String font) {
        }

        @Override
        public void addJavascript(String url) {
        }

        @Override
        public void addJavascriptModule(String url) {
        }

        @Override
        public void addSvgSymbol(String id, String resourcePath) {
        }

        @Override
        public void addSvgSymbol(String id, InputStream resource) {
        }
    }
}

