/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.tucker;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jextra.tucker.encoder.Encoder;
import net.jextra.tucker.tucker.Hook;
import net.jextra.tucker.tucker.HookBinding;

public class Scope {
    private Map<String, String> varValues = new HashMap<String, String>();
    private Map<String, Boolean> boolValues = new HashMap<String, Boolean>();
    private List<HookBinding> bindings = new ArrayList<HookBinding>();

    public Scope() {
    }

    public Scope(Scope other) {
        this();
        for (String key : other.varValues.keySet()) {
            this.varValues.put(key, other.getVariable(key));
        }
        for (String key : other.boolValues.keySet()) {
            this.boolValues.put(key, other.getBoolean(key));
        }
        for (HookBinding binding : other.bindings) {
            this.bindings.add(new HookBinding(binding));
        }
    }

    public void clear() {
        this.varValues.clear();
        this.boolValues.clear();
    }

    public Set<String> getVariableNames() {
        return this.varValues.keySet();
    }

    public boolean hasVariable(String name) {
        return this.varValues.containsKey(name);
    }

    public String getVariable(String name) {
        return this.varValues.get(name);
    }

    public Scope setVariable(String name, String value) {
        return this.setVariable(name, value, true);
    }

    public Scope setVariable(String name, String ... values) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String v : values) {
            if (v == null) continue;
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(v);
            ++count;
        }
        return this.setVariable(name, count > 0 ? builder.toString() : null);
    }

    public Scope setVariable(String name, Collection<String> values) {
        if (values == null) {
            return this.setVariable(name, (String)null);
        }
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String v : values) {
            if (v == null) continue;
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(v);
            ++count;
        }
        return this.setVariable(name, count > 0 ? builder.toString() : null);
    }

    public Scope setVariable(String name, String value, Boolean encode) {
        if (encode.booleanValue()) {
            this.varValues.put(name, Encoder.encodeForHtml(value));
        } else {
            this.varValues.put(name, value);
        }
        return this;
    }

    public boolean hasBoolean(String name) {
        return this.boolValues.containsKey(name);
    }

    public boolean getBoolean(String name) {
        return this.boolValues.get(name) == null ? false : this.boolValues.get(name);
    }

    public Scope setBoolean(String name) {
        return this.setBoolean(name, true);
    }

    public Scope clearBoolean(String name) {
        this.boolValues.remove(name);
        return this;
    }

    public Scope setBoolean(String name, boolean value) {
        this.boolValues.put(name, value);
        return this;
    }

    public void bind(String hookSelector, Hook hook) {
        this.bindings.add(new HookBinding(hookSelector, hook));
    }

    public <T extends Hook> T bind(String hookSelector, Class<T> hookClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Hook hook = (Hook)hookClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.bind(hookSelector, hook);
        return (T)hook;
    }

    public List<HookBinding> getBindings() {
        return this.bindings;
    }
}

