/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.tucker;

import java.util.ArrayDeque;
import java.util.Deque;
import net.jextra.tucker.tucker.Hook;
import net.jextra.tucker.tucker.HookBinding;
import net.jextra.tucker.tucker.Node;
import net.jextra.tucker.tucker.Scope;

public class ScopeContext {
    public static final String INDENT_WHITESPACE = "  ";
    private Deque<Scope> stack = new ArrayDeque<Scope>();
    private int indent;

    public ScopeContext() {
    }

    public ScopeContext(ScopeContext other) {
        this();
        for (Scope scope : other.stack) {
            this.stack.add(new Scope(scope));
        }
        this.indent = other.indent;
    }

    public void push(Scope scope) {
        this.stack.push(scope);
    }

    public Scope pop() {
        return this.stack.pop();
    }

    public String getVariable(String name) {
        Scope s = this.stack.peek();
        if (s != null) {
            return s.getVariable(name);
        }
        return null;
    }

    public boolean getBoolean(String name) {
        Scope s = this.stack.peek();
        if (s != null) {
            return s.getBoolean(name);
        }
        return false;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public String getIndentWhitespace() {
        return this.getIndentWhitespace(0);
    }

    public String getIndentWhitespace(int extraIndent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.indent + extraIndent; ++i) {
            builder.append(INDENT_WHITESPACE);
        }
        return builder.toString();
    }

    public Hook findHook(Node node) {
        for (HookBinding binding : this.stack.peek().getBindings()) {
            if (!binding.matches(node)) continue;
            return binding.getHook();
        }
        return null;
    }
}

