/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.tucker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.jextra.tucker.tucker.Attribute;
import net.jextra.tucker.tucker.Block;
import net.jextra.tucker.tucker.Hook;
import net.jextra.tucker.tucker.Node;
import net.jextra.tucker.tucker.Segment;
import net.jextra.tucker.tucker.TuckerParser;

public class Tucker {
    public static final char LEFT_BRACE = '\u0001';
    public static final char RIGHT_BRACE = '\u0002';
    public static final char BACK_TICK = '\u0003';
    public static final char VAR_START = '\u0004';
    public static final char VAR_END = '\u0005';
    public static final char PHRASE_START = '\u0006';
    public static final char PHRASE_END = '\u0007';
    public static final char BOOL_START = '\u001c';
    public static final char BOOL_END = '\u001d';
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    private TuckerParser parser = new TuckerParser();
    private List<Hook> customTags = new ArrayList<Hook>();

    public Tucker() {
    }

    public Tucker(Path path) throws IOException {
        this();
        this.parse(path);
    }

    public Tucker(File file) throws IOException {
        this();
        this.parse(file);
    }

    public Tucker(InputStream inputStream) throws IOException {
        this();
        this.parse(inputStream);
    }

    public Tucker(URL asset) throws IOException {
        this();
        this.parse(asset);
    }

    public Tucker(BufferedReader reader) throws IOException {
        this();
        this.parse(reader);
    }

    public void parse(Path path) throws IOException {
        this.parser.parse(path);
    }

    public void parse(File file) throws IOException {
        this.parser.parse(file);
    }

    public void parse(InputStream inputStream) throws IOException {
        this.parser.parse(inputStream);
    }

    public void parse(URL asset) throws IOException {
        this.parser.parse(asset);
    }

    public void parse(BufferedReader reader) throws IOException {
        this.parser.parse(reader);
    }

    public void registerCustomTags(Hook tag) {
        this.customTags.add(tag);
    }

    public Block buildBlock(String blockName) {
        Block template = this.parser.getBlock(blockName);
        if (template == null) {
            return null;
        }
        Block block = new Block(template);
        return block;
    }

    private void printTokens() {
        for (Block block : this.parser.getBlocks()) {
            System.out.printf("In | %-9s | %s\n", "Type", "Value");
            System.out.println("----------------------------------------------------------------------");
            System.out.printf("%02d | %-9s | %s\n", new Object[]{block.getIndent(), block.getType(), block.getTagName()});
            for (Node node : block.getChildren()) {
                System.out.printf("%02d | %-9s | %s\n", new Object[]{node.getIndent(), node.getType(), node.getTagName()});
                for (Segment seg : node.getSegments()) {
                    System.out.printf(" . | %-9s | %s\n", new Object[]{seg.getType(), seg.getValue()});
                }
            }
            System.out.println();
        }
    }

    public void printBlock(Block block) {
        System.out.printf("block name[%s]\n", block.getTagName());
        this.printChildren(block.getChildren(), 1);
        System.out.println();
    }

    private void printChildren(List<Node> nodes, int depth) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            StringBuilder prefix = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                prefix.append(".   ");
            }
            StringBuilder atts = new StringBuilder();
            for (String key : node.getAttributes().keySet()) {
                Attribute att = node.getAttribute(key);
                atts.append(String.format(" %s=\"%s\"", key, att == null ? "null" : att.getValue()));
            }
            System.out.printf("%s%s(%s)%s\n", new Object[]{prefix, node.getTagName(), node.getType(), atts});
            if (atts.length() > 0) {
                System.out.printf("%s|%s\n", prefix, atts);
            }
            this.printChildren(node.getChildren(), depth + 1);
        }
    }
}

