/*
 * Decompiled with CFR 0.152.
 */
package net.jextra.tucker.tucker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.jextra.tucker.tucker.Attribute;
import net.jextra.tucker.tucker.Block;
import net.jextra.tucker.tucker.Node;
import net.jextra.tucker.tucker.Segment;

public class TuckerParser {
    public static final char LEFT_BRACE = '\u0001';
    public static final char RIGHT_BRACE = '\u0002';
    public static final char BACK_TICK = '\u0003';
    public static final char VAR_START = '\u0004';
    public static final char VAR_END = '\u0005';
    public static final char PHRASE_START = '\u0006';
    public static final char PHRASE_END = '\u0007';
    public static final char BOOL_START = '\u001c';
    public static final char BOOL_END = '\u001d';
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    private int row;
    private HashMap<String, Block> blocks;
    private Block activeBlock;
    private List<Problem> problems;

    public List<Problem> parse(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            List<Problem> list = this.parse(reader);
            return list;
        }
    }

    public List<Problem> parse(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            List<Problem> list = this.parse(reader);
            return list;
        }
    }

    public List<Problem> parse(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            List<Problem> list = this.parse(reader);
            return list;
        }
    }

    public List<Problem> parse(URL asset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(asset.openStream()));){
            List<Problem> list = this.parse(reader);
            return list;
        }
    }

    public List<Problem> parse(BufferedReader in) throws IOException {
        this.blocks = new LinkedHashMap<String, Block>();
        this.problems = new ArrayList<Problem>();
        this.activeBlock = null;
        this.lexLines(in);
        for (Block block : this.blocks.values()) {
            this.buildHierarchy(block);
        }
        return this.problems;
    }

    public Collection<Block> getBlocks() {
        return this.blocks.values();
    }

    public Block getBlock(String blockName) {
        return this.blocks.get(blockName);
    }

    private void lexLines(BufferedReader in) throws IOException {
        this.row = 1;
        String line = in.readLine();
        while (line != null) {
            int i;
            for (i = 0; i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t'); ++i) {
            }
            if (i < line.length()) {
                this.lexLine(line, i);
            }
            line = in.readLine();
            ++this.row;
        }
    }

    private void lexLine(String line, int indent) throws IOException {
        char c = line.charAt(indent);
        switch (c) {
            case '#': 
            case '/': {
                break;
            }
            case '=': {
                this.lexBlock(line, indent + 1);
                break;
            }
            case '>': {
                if (this.activeBlock != null) {
                    Node node = this.lexInsertionPoint(line, indent + 1);
                    if (node == null) break;
                    node.setIndent(indent);
                    node.setRow(this.row);
                    this.activeBlock.addChild(node);
                    break;
                }
                this.problems.add(new Problem(this.row, "Insertion Point cannot be outside of a block definition"));
                break;
            }
            default: {
                if (this.activeBlock != null) {
                    line = this.transformSpecials(line, indent);
                    Node node = this.lexTag(line);
                    node.setIndent(indent);
                    node.setRow(this.row);
                    this.activeBlock.addChild(node);
                    for (Segment segment : node.getSegments()) {
                        if (segment.getType() != Segment.Type.inline) continue;
                        Node inlineNode = this.lexTag(segment.getValue());
                        inlineNode.setInline(true);
                        segment.setNode(inlineNode);
                    }
                    break;
                }
                this.problems.add(new Problem(this.row, "Tag is outside of a block definition"));
            }
        }
    }

    private String transformSpecials(String line, int indent) {
        VarState state = VarState.SCAN;
        StringBuilder builder = new StringBuilder();
        StringBuilder varNameBuilder = new StringBuilder();
        boolean inPhrase = false;
        boolean inVarParen = false;
        block28: for (int i = indent; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (state) {
                case SCAN: {
                    switch (c) {
                        case '\\': {
                            state = VarState.bang;
                            continue block28;
                        }
                        case '$': {
                            state = VarState.varStart;
                            inVarParen = false;
                            continue block28;
                        }
                        case '&': {
                            state = VarState.boolStart;
                            continue block28;
                        }
                        case '`': {
                            builder.append(inPhrase ? (char)'\u0007' : '\u0006');
                            inPhrase = !inPhrase;
                            continue block28;
                        }
                    }
                    builder.append(c);
                    continue block28;
                }
                case bang: {
                    switch (c) {
                        case '\\': {
                            builder.append('\\');
                            break;
                        }
                        case '$': {
                            builder.append('$');
                            break;
                        }
                        case '&': {
                            builder.append('&');
                            break;
                        }
                        case '{': {
                            builder.append('\u0001');
                            break;
                        }
                        case '}': {
                            builder.append('\u0002');
                            break;
                        }
                        case '`': {
                            builder.append('\u0003');
                            break;
                        }
                        default: {
                            builder.append('\\');
                            builder.append(c);
                            this.problems.add(new Problem(this.row, "Illegal character banged '" + c + "'"));
                        }
                    }
                    state = VarState.SCAN;
                    continue block28;
                }
                case varStart: 
                case boolStart: {
                    VarState nextState = state == VarState.varStart ? VarState.var : VarState.bool;
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block28;
                        }
                        case '(': {
                            state = nextState;
                            inVarParen = true;
                            continue block28;
                        }
                    }
                    if (this.isVarChar(c)) {
                        varNameBuilder.append(c);
                        state = nextState;
                        continue block28;
                    }
                    --i;
                    state = VarState.SCAN;
                    continue block28;
                }
                case var: 
                case bool: {
                    boolean isVarDone = false;
                    if (inVarParen && c == ')') {
                        isVarDone = true;
                    } else if (this.isVarChar(c) || inVarParen) {
                        varNameBuilder.append(c);
                    } else {
                        isVarDone = true;
                        --i;
                    }
                    if (!isVarDone) continue block28;
                    builder.append(state == VarState.bool ? (char)'\u001c' : '\u0004');
                    builder.append(varNameBuilder.toString().trim());
                    builder.append(state == VarState.bool ? (char)'\u001d' : '\u0005');
                    varNameBuilder.setLength(0);
                    state = VarState.SCAN;
                    inVarParen = false;
                }
            }
        }
        switch (state) {
            case var: {
                builder.append('\u0004');
                builder.append((CharSequence)varNameBuilder);
                builder.append('\u0005');
                varNameBuilder.setLength(0);
                break;
            }
            case bool: {
                builder.append('\u001c');
                builder.append((CharSequence)varNameBuilder);
                builder.append('\u001d');
                varNameBuilder.setLength(0);
            }
        }
        return builder.toString();
    }

    private boolean isVarChar(char c) {
        if (Character.isAlphabetic(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        switch (c) {
            case '-': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private Block lexBlock(String line, int indent) {
        StringBuilder builder = new StringBuilder();
        block4: for (int i = indent; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '=': {
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        String name = builder.toString().trim();
        if (name.isEmpty()) {
            return null;
        }
        this.activeBlock = new Block(name);
        this.blocks.put(this.activeBlock.getTagName(), this.activeBlock);
        return this.activeBlock;
    }

    private Node lexInsertionPoint(String line, int indent) {
        StringBuilder builder = new StringBuilder();
        block3: for (int i = indent; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        String name = builder.toString().trim();
        if (name.isEmpty()) {
            return null;
        }
        Node node = new Node(Node.NodeType.insertion);
        node.setTagName(name);
        return node;
    }

    private Node lexTag(String line) throws IOException {
        int pos;
        State state = State.tag;
        StringBuilder tagBuilder = new StringBuilder();
        for (pos = 0; pos < line.length(); ++pos) {
            char c = line.charAt(pos);
            switch (c) {
                case '#': {
                    state = State.id;
                    break;
                }
                case '.': {
                    state = State.className;
                    break;
                }
                case '|': {
                    state = State.pipeStart;
                    break;
                }
                case '\t': 
                case ' ': {
                    state = State.attributeStart;
                    break;
                }
                default: {
                    tagBuilder.append(c);
                }
            }
            if (state != State.tag) break;
        }
        Node node = new Node(Node.NodeType.tag);
        node.setTagName(tagBuilder.toString().trim());
        if (node.getTagName().isEmpty()) {
            this.problems.add(new Problem(this.row, String.format("Tag cannot have an empty name. Defaulting to '%s'", "div")));
            node.setTagName("div");
        }
        if (state == State.id || state == State.className) {
            pos = this.lexTagShortcuts(node, line, pos + 1, state);
        }
        pos = this.lexAttributes(node, line, pos);
        this.lexPipeData(node, line, pos);
        return node;
    }

    private int lexTagShortcuts(Node node, String line, int indent, State state) throws IOException {
        StringBuilder id = new StringBuilder();
        StringBuilder className = new StringBuilder();
        block14: for (int pos = indent; pos < line.length(); ++pos) {
            char c = line.charAt(pos);
            switch (state) {
                case id: {
                    switch (c) {
                        case '#': {
                            throw new IOException("Cannot specify more than one # id shortcut");
                        }
                        case '.': {
                            node.addAttribute("id", id.toString());
                            id.setLength(0);
                            state = State.className;
                            continue block14;
                        }
                        case ' ': {
                            node.addAttribute("id", id.toString());
                            id.setLength(0);
                            return pos + 1;
                        }
                    }
                    id.append(c);
                    continue block14;
                }
                case className: {
                    switch (c) {
                        case '#': {
                            node.addAttribute("class", className.toString());
                            className.setLength(0);
                            state = State.id;
                            continue block14;
                        }
                        case '.': {
                            node.addAttribute("class", className.toString());
                            className.setLength(0);
                            state = State.className;
                            continue block14;
                        }
                        case ' ': {
                            node.addAttribute("class", className.toString());
                            className.setLength(0);
                            return pos + 1;
                        }
                    }
                    className.append(c);
                }
            }
        }
        if (id.length() > 0) {
            node.addAttribute("id", id.toString());
        }
        if (className.length() > 0) {
            node.addAttribute("class", className.toString());
        }
        return -1;
    }

    private int lexAttributes(Node node, String line, int indent) {
        if (indent == -1) {
            return -1;
        }
        State state = State.attributeStart;
        StringBuilder attNameBuilder = new StringBuilder();
        StringBuilder attValueBuilder = new StringBuilder();
        String activeAttName = null;
        block32: for (int pos = indent; pos < line.length(); ++pos) {
            char c = line.charAt(pos);
            switch (state) {
                case attributeStart: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block32;
                        }
                        case '|': {
                            return pos + 1;
                        }
                    }
                    attNameBuilder.append(c);
                    state = State.attributeName;
                    continue block32;
                }
                case attributeName: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            activeAttName = attNameBuilder.toString();
                            attNameBuilder.setLength(0);
                            state = State.attributeBetween;
                            continue block32;
                        }
                        case '=': {
                            activeAttName = attNameBuilder.toString();
                            attNameBuilder.setLength(0);
                            state = State.attributeValueStart;
                            continue block32;
                        }
                        case '|': {
                            activeAttName = attNameBuilder.toString();
                            attNameBuilder.setLength(0);
                            if (activeAttName != null && !activeAttName.isEmpty()) {
                                node.addAttribute(activeAttName);
                            }
                            return pos + 1;
                        }
                    }
                    attNameBuilder.append(c);
                    continue block32;
                }
                case attributeBetween: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block32;
                        }
                        case '=': {
                            state = State.attributeValueStart;
                            continue block32;
                        }
                        case '|': {
                            if (activeAttName != null && !activeAttName.isEmpty()) {
                                node.addAttribute(activeAttName);
                            }
                            return pos + 1;
                        }
                    }
                    if (activeAttName != null && !activeAttName.isEmpty()) {
                        node.addAttribute(activeAttName);
                    }
                    attNameBuilder.append(c);
                    state = State.attributeStart;
                    continue block32;
                }
                case attributeValueStart: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block32;
                        }
                        case '\"': {
                            state = State.attributeValue;
                            continue block32;
                        }
                    }
                    attNameBuilder.setLength(0);
                    activeAttName = null;
                    state = State.attributeStart;
                    continue block32;
                }
                case attributeValue: {
                    switch (c) {
                        case '\"': {
                            if (activeAttName != null && !activeAttName.isEmpty()) {
                                node.addAttribute(activeAttName, attValueBuilder.toString());
                                activeAttName = null;
                            }
                            attNameBuilder.setLength(0);
                            attValueBuilder.setLength(0);
                            state = State.attributeStart;
                            continue block32;
                        }
                        case '\\': {
                            state = State.attributeValueBang;
                            continue block32;
                        }
                    }
                    attValueBuilder.append(c);
                    continue block32;
                }
                case attributeValueBang: {
                    switch (c) {
                        default: 
                    }
                    attValueBuilder.append(c);
                    state = State.attributeValue;
                }
            }
        }
        if (attNameBuilder.length() > 0) {
            node.addAttribute(attNameBuilder.toString());
        }
        return -1;
    }

    private int lexPipeData(Node node, String line, int indent) {
        if (indent == -1) {
            return -1;
        }
        State state = State.pipeStart;
        StringBuilder textBuilder = new StringBuilder();
        StringBuilder inlineBuilder = new StringBuilder();
        StringBuilder varBuilder = new StringBuilder();
        block19: for (int pos = indent; pos < line.length(); ++pos) {
            char c = line.charAt(pos);
            switch (state) {
                case pipeStart: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block19;
                        }
                        case '{': {
                            state = State.inlineStart;
                            continue block19;
                        }
                    }
                    textBuilder.append(c);
                    state = State.pipe;
                    continue block19;
                }
                case pipe: {
                    Segment segment;
                    switch (c) {
                        case '{': {
                            segment = new Segment(Segment.Type.text, textBuilder.toString());
                            node.addSegment(segment);
                            textBuilder.setLength(0);
                            state = State.inlineStart;
                            continue block19;
                        }
                    }
                    textBuilder.append(c);
                    continue block19;
                }
                case inlineStart: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block19;
                        }
                    }
                    inlineBuilder.append(c);
                    state = State.inline;
                    continue block19;
                }
                case inline: {
                    Segment segment;
                    switch (c) {
                        case '}': {
                            segment = new Segment(Segment.Type.inline, inlineBuilder.toString());
                            node.addSegment(segment);
                            inlineBuilder.setLength(0);
                            state = State.pipe;
                            continue block19;
                        }
                    }
                    inlineBuilder.append(c);
                }
            }
        }
        if (textBuilder.length() > 0) {
            Segment segment = new Segment(Segment.Type.text, textBuilder.toString());
            node.addSegment(segment);
        }
        return -1;
    }

    private void printTokens() {
        for (Block block : this.blocks.values()) {
            System.out.printf("In | %-9s | %s\n", "Type", "Value");
            System.out.println("----------------------------------------------------------------------");
            System.out.printf("%02d | %-9s | %s\n", new Object[]{block.getIndent(), block.getType(), block.getTagName()});
            for (Node node : block.getChildren()) {
                System.out.printf("%02d | %-9s | %s\n", new Object[]{node.getIndent(), node.getType(), node.getTagName()});
                for (Segment seg : node.getSegments()) {
                    System.out.printf(" . | %-9s | %s\n", new Object[]{seg.getType(), seg.getValue()});
                }
            }
            System.out.println();
        }
    }

    private void printBlock(Block block) {
        System.out.printf("block name[%s]\n", block.getTagName());
        this.printChildren(block.getChildren(), 1);
        System.out.println();
    }

    private void printChildren(List<Node> nodes, int depth) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            StringBuilder prefix = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                prefix.append(".   ");
            }
            StringBuilder atts = new StringBuilder();
            for (String key : node.getAttributes().keySet()) {
                Attribute att = node.getAttribute(key);
                atts.append(String.format(" %s=\"%s\"", key, att == null ? "null" : att.getValue()));
            }
            System.out.printf("%s%s type[%s] segs[%d]%s\n", new Object[]{prefix, node.getTagName(), node.getType(), node.getSegments().size(), atts});
            for (Segment seg : node.getSegments()) {
                System.out.printf("%s|%s\n", prefix, seg);
            }
            this.printChildren(node.getChildren(), depth + 1);
        }
    }

    private void buildHierarchy(Block block) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        HashMap<Node, Integer> depths = new HashMap<Node, Integer>();
        int depth = 0;
        for (Node node : block.getChildren()) {
            int indent = node.getIndent();
            if (map.isEmpty()) {
                map.put(depth, indent);
            } else if (indent != (Integer)map.get(depth)) {
                if (indent > (Integer)map.get(depth)) {
                    map.put(++depth, indent);
                } else {
                    while (depth > 0 && indent < (Integer)map.get(depth)) {
                        --depth;
                    }
                    map.put(depth, indent);
                }
            }
            depths.put(node, depth);
        }
        HashMap<Integer, Node> parents = new HashMap<Integer, Node>();
        ArrayList<Node> roots = new ArrayList<Node>();
        for (Node node : block.getChildren()) {
            int d = (Integer)depths.get(node);
            Node parent = (Node)parents.get(d - 1);
            if (parent == null) {
                roots.add(node);
            } else {
                parent.addChild(node);
            }
            if (node.getNodeType() != Node.NodeType.tag) continue;
            parents.put(d, node);
        }
        block.clearChildren();
        for (Node root : roots) {
            block.addChild(root);
        }
    }

    public static class Problem {
        private int row;
        private String message;

        Problem(int row, String message) {
            this.row = row;
            this.message = message;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return String.format("%d: %s", this.row, this.message);
        }
    }

    private static enum VarState {
        SCAN,
        bang,
        varStart,
        var,
        boolStart,
        bool;

    }

    private static enum State {
        tag,
        id,
        className,
        attributeStart,
        attributeName,
        attributeBetween,
        attributeValueStart,
        attributeValue,
        attributeValueBang,
        inline,
        inlineStart,
        pipeStart,
        pipe,
        raw;

    }
}

