/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jmatrix.jproperties.JPRuntimeException;
import net.jmatrix.jproperties.WrappedProperties;
import net.jmatrix.jproperties.parser.Parser;
import net.jmatrix.jproperties.substitution.SubstitutionProcessor;
import net.jmatrix.jproperties.util.ClassLogFactory;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JProperties
implements Map<String, Object> {
    public static long DEFAULT_LONG = -1L;
    public static int DEFAULT_INT = -1;
    public static boolean DEFAULT_BOOLEAN = false;
    public static Log log = ClassLogFactory.getLog();
    Map<String, Object> data = new LinkedHashMap<String, Object>();
    private JProperties parent = null;
    private String url = null;
    private boolean processSubstitutions = true;
    private boolean processInclusions = true;

    public JProperties() {
    }

    public JProperties(Properties p) {
        this((Map<String, Object>)p);
    }

    public JProperties(Map<String, Object> map) {
        log.debug((Object)"map constructor.");
        if (map == null) {
            throw new NullPointerException("Constructing JProperties from Null map.");
        }
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                this.put(key, value);
                continue;
            }
            if (Map.class.isAssignableFrom(value.getClass())) {
                JProperties np = new JProperties((Map)value);
                np.parent = this;
                this.put(key, (Object)np);
                continue;
            }
            if (List.class.isAssignableFrom(value.getClass())) {
                List l = (List)value;
                this.put(key, (Object)JProperties.convertlist(l, this));
                continue;
            }
            log.debug((Object)("Map Unknown object type: " + value.getClass().getName() + ": " + value));
        }
    }

    public String toString() {
        return Parser.writeAsJson(this);
    }

    private static final List convertlist(List l, JProperties parent) {
        ArrayList c = new ArrayList();
        for (Object o : l) {
            if (o == null) continue;
            if (o instanceof String || o instanceof Number || o instanceof Boolean) {
                c.add(o);
                continue;
            }
            if (Map.class.isAssignableFrom(o.getClass())) {
                JProperties p = new JProperties((Map)o);
                p.setParent(parent);
                c.add(p);
                continue;
            }
            if (List.class.isAssignableFrom(o.getClass())) {
                c.add(JProperties.convertlist((List)o, parent));
                continue;
            }
            log.debug((Object)("List Unknown object type: " + o.getClass().getName() + ": " + o));
        }
        return c;
    }

    public Object findValue(String key) {
        Object val = this.get(key);
        if (val != null) {
            return val;
        }
        if (this.parent != null) {
            return this.parent.findValue(key);
        }
        return val;
    }

    public String findString(String key) {
        Object o = this.findValue(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public void setParent(JProperties p) {
        this.parent = p;
        this.processInclusions = p.processInclusions;
        this.processSubstitutions = p.processSubstitutions;
    }

    public void setUrl(String s) {
        this.url = s;
    }

    public String getUrl() {
        return this.url;
    }

    public String findUrl() {
        if (this.url != null) {
            return this.url;
        }
        if (this.parent != null) {
            return this.parent.findUrl();
        }
        return null;
    }

    public Properties toProperties() {
        WrappedProperties p = new WrappedProperties(this);
        p.setAllowKeysWithNullValues(false);
        return p;
    }

    public List<String> getKeys() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.keySet());
        return l;
    }

    public boolean isProcessSubstitutions() {
        return this.processSubstitutions;
    }

    public void setProcessSubstitutions(boolean processSubstitutions) {
        this.processSubstitutions = processSubstitutions;
    }

    public boolean isProcessInclusions() {
        return this.processInclusions;
    }

    public void setProcessInclusions(boolean processInclusions) {
        this.processInclusions = processInclusions;
    }

    @Override
    public Object get(Object okey) {
        if (okey == null) {
            return null;
        }
        String key = okey.toString();
        String[] splitKey = key.split("\\-\\>");
        if (splitKey.length == 1) {
            Object val = this.data.get(key);
            if (!this.processSubstitutions) {
                return val;
            }
            if (val instanceof String) {
                String sval = (String)val;
                if (SubstitutionProcessor.containsTokens(sval)) {
                    return SubstitutionProcessor.processSubstitution(sval, this, Object.class);
                }
                if (SubstitutionProcessor.containsTokens(sval)) {
                    log.warn((Object)("Value for key " + key + " contains unresolvable substitution."));
                }
                return sval;
            }
            if (val instanceof List) {
                List l = (List)val;
                int size = l.size();
                for (int i = 0; i < size; ++i) {
                    Object lo = l.get(i);
                    if (lo instanceof String) {
                        String ls = (String)lo;
                        if (!SubstitutionProcessor.containsTokens(ls)) continue;
                        Object newobj = SubstitutionProcessor.processSubstitution(ls, this, Object.class);
                        l.set(i, newobj);
                        continue;
                    }
                    if (!(lo instanceof JProperties) && !(lo instanceof List)) continue;
                }
                return l;
            }
            return val;
        }
        String remainingKey = key.substring(splitKey[0].length() + 2);
        Object val = this.get(splitKey[0]);
        if (val == null) {
            return null;
        }
        if (val instanceof JProperties) {
            return ((JProperties)val).get(remainingKey);
        }
        log.warn((Object)("Unresolvable key '" + okey + "', at component '" + splitKey[0] + "' does not return nested properties, rather " + (val == null ? "null" : val.getClass().getName())));
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        String[] splitKey = key.split("\\-\\>");
        if (splitKey.length == 1) {
            return this.data.put(key, value);
        }
        String remainingKey = key.substring(splitKey[0].length() + 2);
        JProperties next = null;
        Object val = this.get(splitKey[0]);
        if (val == null) {
            next = new JProperties();
            next.setParent(this);
            this.put(splitKey[0], (Object)next);
        } else if (val instanceof JProperties) {
            next = (JProperties)val;
        } else {
            throw new JPRuntimeException("Unresolvable put key '" + key + "', at component '" + splitKey[0] + "' does not return nested properties, rather " + val.getClass().getName());
        }
        return next.put(remainingKey, value);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> oset = this.data.entrySet();
        LinkedHashSet<Map.Entry<String, Object>> nset = new LinkedHashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : oset) {
            nset.add(new JPropertiesEntry(entry));
        }
        return nset;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.data.keySet();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.data.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        return this.data.remove(key);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Collection<Object> values() {
        throw new JPRuntimeException("values not supported.");
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        return o.toString();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, DEFAULT_BOOLEAN);
    }

    public boolean getBoolean(String key, boolean def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("yes");
        }
        return false;
    }

    public int getInt(String key) {
        return this.getInt(key, DEFAULT_INT);
    }

    public int getInt(String key, int def) {
        return (int)this.getLong(key, def);
    }

    public long getLong(String key) {
        return this.getLong(key, DEFAULT_LONG);
    }

    public long getLong(String key, long def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Long.parseLong(((String)o).trim());
            }
            catch (NumberFormatException ex) {
                log.debug((Object)("Cannot parse number from '" + o + "'"));
            }
        }
        return def;
    }

    public JProperties getProperties(String key) {
        Object o = this.get(key);
        if (o instanceof JProperties) {
            return (JProperties)o;
        }
        return null;
    }

    public List getList(String key) {
        Object o = this.get(key);
        if (o instanceof List) {
            return (List)o;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JPropertiesEntry
    implements Map.Entry<String, Object> {
        String key = null;

        public JPropertiesEntry(Map.Entry<String, Object> entry) {
            this.key = entry.getKey();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return JProperties.this.get(this.key);
        }

        @Override
        public Object setValue(Object value) {
            return JProperties.this.put(this.key, value);
        }
    }
}

