/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import net.jmatrix.jproperties.JPRuntimeException;
import net.jmatrix.jproperties.JProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WrappedProperties
extends Properties {
    static final Log log = LogFactory.getLog(WrappedProperties.class);
    JProperties jproperties;
    Character delimiter = null;
    public boolean debug = false;
    boolean allowKeysWithNullValues = true;

    public WrappedProperties(JProperties jp) {
        this(jp, Character.valueOf('.'));
    }

    public WrappedProperties(JProperties jp, Character del) {
        this.jproperties = jp;
        this.delimiter = del;
    }

    public boolean isAllowKeysWithNullValues() {
        return this.allowKeysWithNullValues;
    }

    public void setAllowKeysWithNullValues(boolean allowKeysWithNullValues) {
        this.allowKeysWithNullValues = allowKeysWithNullValues;
    }

    public String getProperty(String key, String def) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        String ikey = null;
        if (this.delimiter != null) {
            String[] components = key.split("\\" + this.delimiter);
            if (components.length > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < components.length - 1; ++i) {
                    sb.append(components[i] + "->");
                }
                sb.append(components[components.length - 1]);
                ikey = sb.toString();
            } else {
                ikey = key;
            }
        } else {
            ikey = key;
        }
        String value = this.jproperties.getString(ikey);
        if (value == null && def == null) {
            log.info((Object)("Value is null for property key '" + key + "'"));
        }
        return value == null ? def : value;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        return this.getProperty(key.toString());
    }

    public Enumeration keys() {
        return new KeyEnumeration();
    }

    public Enumeration propertyNames() {
        return this.keys();
    }

    class KeyEnumeration
    implements Enumeration {
        Iterator<String> iterator = null;

        public KeyEnumeration() {
            log.debug((Object)("Creating KeyEnumeration, allowKeysWithNullValues=" + WrappedProperties.this.allowKeysWithNullValues));
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            if (WrappedProperties.this.debug) {
                System.err.println("Building flat key enumeration, delim=" + WrappedProperties.this.delimiter);
            }
            HashMap<String, Iterator<String>> iterMap = new HashMap<String, Iterator<String>>();
            HashMap<String, JProperties> propMap = new HashMap<String, JProperties>();
            Iterator<String> currentIterator = WrappedProperties.this.jproperties.keySet().iterator();
            String currentPath = "";
            JProperties currentProps = WrappedProperties.this.jproperties;
            while (currentIterator != null && currentPath != null) {
                if (!currentIterator.hasNext()) {
                    String parentPath = null;
                    parentPath = currentPath.indexOf("" + WrappedProperties.this.delimiter) != -1 ? currentPath.substring(0, currentPath.lastIndexOf("" + WrappedProperties.this.delimiter)) : (currentPath == "" ? null : "");
                    if (WrappedProperties.this.debug) {
                        System.err.println("  Backing up to '" + parentPath + "'");
                    }
                    if (parentPath != null) {
                        currentIterator = (Iterator<String>)iterMap.get(parentPath);
                        currentProps = (JProperties)propMap.get(parentPath);
                    }
                    currentPath = parentPath;
                    continue;
                }
                String key = currentIterator.next();
                if (key.contains("" + WrappedProperties.this.delimiter)) {
                    throw new JPRuntimeException("Key '" + key + "' at path:" + currentPath + " contains the delimter '" + WrappedProperties.this.delimiter + "'.  When using WrappedProperties " + "around a JProperties tree - the delimeter cannot be part of a key.");
                }
                Object value = currentProps.get(key);
                if (value instanceof JProperties) {
                    JProperties children = (JProperties)value;
                    iterMap.put(currentPath, currentIterator);
                    propMap.put(currentPath, currentProps);
                    currentPath = currentPath.length() > 0 ? currentPath + WrappedProperties.this.delimiter + key : key;
                    if (WrappedProperties.this.debug) {
                        System.err.println("  Descending into " + currentPath);
                    }
                    currentProps = children;
                    currentIterator = currentProps.keySet().iterator();
                    continue;
                }
                String flatkey = null;
                flatkey = currentPath.length() > 0 ? currentPath + WrappedProperties.this.delimiter + key : key;
                if (value != null || WrappedProperties.this.allowKeysWithNullValues) {
                    if (WrappedProperties.this.debug) {
                        System.err.println("     Adding key " + flatkey);
                    }
                    keys.add(flatkey);
                    continue;
                }
                if (!WrappedProperties.this.debug) continue;
                System.out.println("      Ignoring key w/ null value " + flatkey);
            }
            if (WrappedProperties.this.debug) {
                System.err.println("Keys: " + keys);
            }
            this.iterator = keys.iterator();
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

