/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.parser;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jmatrix.jproperties.JPRuntimeException;
import net.jmatrix.jproperties.JProperties;
import net.jmatrix.jproperties.post.IncludePostProcessor;
import net.jmatrix.jproperties.util.ClassLogFactory;
import net.jmatrix.jproperties.util.GenericLogConfig;
import net.jmatrix.jproperties.util.URLUtil;
import org.apache.commons.logging.Log;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.TypeReference;

public class Parser {
    public static Log log = ClassLogFactory.getLog();

    public static void main(String[] args) throws Exception {
        GenericLogConfig.bootstrap();
        File input = new File(args[0]);
        JProperties p = Parser.parse(input);
        System.out.println("Parsed tree: " + p);
        System.out.println("PreTree: " + Parser.writeAsJson(p));
        for (String key : p.keySet()) {
            System.out.println("   key: " + key);
        }
        IncludePostProcessor post = new IncludePostProcessor();
        post.post(p);
        log.debug((Object)"Done Postprocessing.");
        System.out.println("PostTree: " + Parser.writeAsJson(p));
    }

    public static JProperties parse(String surl) throws IOException {
        String iurl = URLUtil.convertClasspathURL(surl);
        log.debug((Object)("Parser convered URL '" + surl + "' -> '" + iurl + "'"));
        URL url = new URL(iurl);
        return Parser.parse(url);
    }

    public static JProperties parse(File f) throws IOException {
        JProperties p = Parser.parse(new FileReader(f));
        p.setUrl(f.toURI().toURL().toString());
        IncludePostProcessor post = new IncludePostProcessor();
        post.post(p);
        return p;
    }

    public static JProperties parse(URL url) throws IOException {
        InputStream is = url.openStream();
        log.debug((Object)("Stream opend for " + url + ": " + is));
        JProperties p = Parser.parse(new InputStreamReader(is));
        p.setUrl(url.toString());
        IncludePostProcessor post = new IncludePostProcessor();
        post.post(p);
        return p;
    }

    public static JProperties parse(Reader r) throws JsonParseException, JsonMappingException, IOException {
        TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        ObjectMapper om = new ObjectMapper(factory);
        Map map = (Map)om.readValue(r, (TypeReference)typeRef);
        JProperties p = new JProperties(map);
        return p;
    }

    public static void write(JProperties jp, Writer w) throws IOException {
        jp.setProcessSubstitutions(false);
        String s = Parser.writeAsJson(jp);
        System.err.println("Serialized size: " + s.length());
        w.write(s);
        w.flush();
    }

    public static void write(JProperties jp, File f) throws IOException {
        Parser.write(jp, new FileWriter(f));
    }

    public static String toJson(JProperties jp) {
        return Parser.writeAsJson(jp);
    }

    public static final String writeAsJson(Object o) {
        return Parser.writeAsJson(o, true);
    }

    public static final String writeAsJson(Object o, boolean indent) {
        ObjectMapper om = new ObjectMapper();
        om.configure(SerializationConfig.Feature.INDENT_OUTPUT, indent);
        om.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        try {
            if (o == null) {
                return "null";
            }
            return om.writeValueAsString(o);
        }
        catch (Exception ex) {
            throw new JPRuntimeException("Error in debug serialization.", ex);
        }
    }
}

