/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.post;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.jmatrix.jproperties.JPRuntimeException;
import net.jmatrix.jproperties.JProperties;
import net.jmatrix.jproperties.parser.Parser;
import net.jmatrix.jproperties.post.Options;
import net.jmatrix.jproperties.util.StreamUtil;
import net.jmatrix.jproperties.util.URLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLPropertiesLoader {
    static Log log = LogFactory.getLog(URLPropertiesLoader.class);

    public boolean acceptsURL(String s) {
        if (s == null) {
            return false;
        }
        return s.toLowerCase().startsWith("file:/") || s.toLowerCase().startsWith("http://") || s.toLowerCase().startsWith("https://") || s.toLowerCase().startsWith("classpath:/");
    }

    public Object loadProperties(JProperties parent, String surl, Options options) {
        Object result = null;
        String lcurl = (surl = URLUtil.convertClasspathURL(surl)).toLowerCase();
        if (lcurl.startsWith("http://") || lcurl.startsWith("https://") || lcurl.startsWith("file:/") || lcurl.startsWith("jar:file:/")) {
            log.debug((Object)("Loading as absolute URL: " + surl));
            result = this.loadFromURL(surl, options, parent);
        } else if (surl.startsWith("/")) {
            log.debug((Object)("Loading as absolute file: " + surl));
            File f = new File(surl);
            if (f.exists()) {
                try {
                    result = this.loadFromURL(f.toURI().toURL().toExternalForm(), options, parent);
                }
                catch (IOException ex) {
                    if (options.failonerror) {
                        throw new JPRuntimeException("Error loading included properties from '" + surl + "'", ex);
                    }
                    log.warn((Object)("Cannot find file '" + surl + "', failonerror=false"));
                }
            } else {
                if (options.failonerror) {
                    throw new JPRuntimeException("Cannot find file '" + surl + "' to include.");
                }
                log.warn((Object)("Cannot find file '" + surl + "' to include. failonerror=false"));
            }
        } else {
            String parentURL = parent.findUrl();
            log.debug((Object)("Loading as relative URL, parent URL is '" + parentURL + "'"));
            if (parentURL == null) {
                File f = new File(surl);
                if (f.exists()) {
                    try {
                        result = this.loadFromURL(f.toURI().toURL().toExternalForm(), options, parent);
                    }
                    catch (IOException ex) {
                        if (options.failonerror) {
                            throw new JPRuntimeException("Error loading included properties from '" + surl + "'", ex);
                        }
                        log.warn((Object)("Cannot find file '" + surl + "', failonerror=false"));
                    }
                } else {
                    if (options.failonerror) {
                        throw new JPRuntimeException("Cannot find file '" + surl + "' to include.");
                    }
                    log.warn((Object)("Cannot find file '" + surl + "' to include. failonerror=false"));
                }
            } else {
                String workingSURL = parentURL.toString();
                workingSURL = workingSURL.substring(0, workingSURL.lastIndexOf("/") + 1) + surl;
                log.debug((Object)("Loading w/ rel URL: '" + workingSURL + "'"));
                result = this.loadFromURL(workingSURL, options, parent);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadFromURL(String surl, Options options, JProperties parent) {
        Object result;
        block10: {
            result = null;
            try {
                URL url = new URL(surl);
                if (options.parse) {
                    if (options.format == Options.Format.PROPERITES) {
                        log.debug((Object)"Options set to java.util.Properties format.");
                        Properties p = new Properties();
                        p.load(url.openStream());
                        JProperties props = new JProperties(p);
                        props.setParent(parent);
                        result = props;
                    } else {
                        JProperties props = Parser.parse(url);
                        props.setParent(parent);
                        result = props;
                    }
                    break block10;
                }
                InputStream is = url.openStream();
                try {
                    String value = StreamUtil.readToString(is);
                    result = value;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException ex) {
                if (options.failonerror) {
                    throw new JPRuntimeException("Error loading included properties from '" + surl + "'", ex);
                }
                log.info((Object)("Cannot load properties from  '" + surl + "', failonerror=false"));
            }
        }
        return result;
    }
}

