/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jmatrix.jproperties.util.ClassLogFactory;
import org.apache.commons.logging.Log;

public class GenericLogConfig {
    public static boolean debug = false;
    static Log log = ClassLogFactory.getLog();
    static final String LOG4J_DEBUG = "DEBUG";

    public static void bootstrap() {
        String loggerClassname = log.getClass().getName();
        System.out.println("Log is " + loggerClassname);
        if (loggerClassname.toLowerCase().contains("log4j")) {
            GenericLogConfig.initLog4J(LOG4J_DEBUG);
        } else {
            GenericLogConfig.initJavaUtilLogging();
        }
    }

    static final void initLog4J(String level) {
        System.out.println("Bootstrapping Log4J w/ Default level '" + level + "'");
        Properties p = new Properties();
        p.put("log4j.rootLogger", level + ", stdout");
        p.put("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        p.put("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        p.put("log4j.appender.stdout.layout.ConversionPattern", "%d{HH:mm:ss.SSS} [%t] %-5p %c{1} %x - %m%n");
        if (debug) {
            System.out.println("Trying to bootstrap log4j with:");
            p.list(System.out);
        }
        try {
            Class<?> clazz = Class.forName("org.apache.log4j.PropertyConfigurator");
            Method method = clazz.getMethod("configure", Properties.class);
            method.invoke(null, p);
        }
        catch (Exception ex) {
            System.out.println("Cannot initialize Log4J even though Commons Logger is '" + log.getClass().getName() + "'");
        }
    }

    static final void initJavaUtilLogging() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = Logger.getLogger("");
        logger.removeHandler(logger.getHandlers()[0]);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new LocalLogFormatter());
        consoleHandler.setLevel(Level.FINEST);
        logger.addHandler(consoleHandler);
        logger.setLevel(Level.ALL);
        if (debug) {
            Enumeration<String> loggers = logManager.getLoggerNames();
            while (loggers.hasMoreElements()) {
                String name = loggers.nextElement();
                Logger l = Logger.getLogger(name);
                System.out.println("   Loggger: " + name);
                System.out.println("          level: " + l.getLevel());
                System.out.println("       handlers: " + Arrays.asList(l.getHandlers()));
                System.out.println("       use parent?: " + l.getUseParentHandlers());
            }
        }
    }

    static class LocalLogFormatter
    extends Formatter {
        DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");

        LocalLogFormatter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            DateFormat dateFormat = this.df;
            synchronized (dateFormat) {
                sb.append(this.df.format(new Date(record.getMillis())) + " ");
            }
            sb.append(record.getLevel() + " ");
            sb.append(record.getThreadID() + ":" + Thread.currentThread().getName() + " ");
            sb.append(LocalLogFormatter.shortLoggerName(record.getLoggerName() + " "));
            sb.append(record.getMessage());
            if (record.getThrown() != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
                record.getThrown().printStackTrace(pw);
                pw.flush();
                sb.append("\n" + baos.toString());
            } else {
                sb.append("\n");
            }
            return sb.toString();
        }

        private static final String shortLoggerName(String loggerName) {
            return loggerName.substring(loggerName.lastIndexOf(".") + 1);
        }
    }
}

