/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.jproperties.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamUtil {
    static final int EOS = -1;

    public static final void pump(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[8192];
        int bytes = is.read(buffer);
        while (bytes > 0) {
            os.write(buffer, 0, bytes);
            bytes = is.read(buffer);
        }
        os.flush();
        os.close();
        is.close();
    }

    public static final void unbufferedPump(InputStream is, OutputStream os) throws IOException {
        int b = is.read();
        while (b != -1) {
            os.write(b);
            b = is.read();
        }
        os.flush();
        os.close();
        is.close();
    }

    public static final void pumpExactly(InputStream is, OutputStream os, int bytes) throws IOException {
        for (int i = 0; i < bytes; ++i) {
            os.write(is.read());
        }
        os.flush();
        os.close();
        is.close();
    }

    public static String readToString(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.pump(is, baos);
        return baos.toString();
    }

    public static byte[] readFully(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = is.read();
        while (b != -1) {
            baos.write(b);
            b = is.read();
        }
        return baos.toByteArray();
    }
}

