/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.console.log;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.jmatrix.console.log.LevelMapper;

public class ANSIColorFormatter
extends Formatter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private Map<org.slf4j.event.Level, String> levelColors = new HashMap<org.slf4j.event.Level, String>();
    private Map<org.slf4j.event.Level, String> levelName = new HashMap<org.slf4j.event.Level, String>();

    public ANSIColorFormatter() {
        this.levelColors.put(org.slf4j.event.Level.ERROR, ANSI_RED);
        this.levelColors.put(org.slf4j.event.Level.WARN, ANSI_YELLOW);
        this.levelColors.put(org.slf4j.event.Level.TRACE, ANSI_PURPLE);
        this.levelColors.put(org.slf4j.event.Level.DEBUG, ANSI_GREEN);
        this.levelName.put(org.slf4j.event.Level.ERROR, "E");
        this.levelName.put(org.slf4j.event.Level.WARN, "W");
        this.levelName.put(org.slf4j.event.Level.INFO, "I");
        this.levelName.put(org.slf4j.event.Level.DEBUG, "D");
        this.levelName.put(org.slf4j.event.Level.TRACE, "T");
    }

    public void setLevelColor(org.slf4j.event.Level level, String color) {
        this.levelColors.put(level, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            sb.append(this.dateFormat.format(new Date(record.getMillis())));
        }
        sb.append(" [" + this.getLevelString(record.getLevel()) + "]");
        sb.append(" {" + Thread.currentThread().getName() + "} ");
        sb.append(ANSIColorFormatter.shortLoggerName(record.getLoggerName() + ": "));
        sb.append(record.getMessage());
        if (record.getThrown() != null) {
            sb.append("\n" + ANSIColorFormatter.stackString(record.getThrown()));
        }
        return sb.toString();
    }

    private final String getLevelString(Level jlevel) {
        org.slf4j.event.Level level = LevelMapper.julToSlfLevel(jlevel);
        return ANSIColorFormatter.color(this.levelColors.get(level), this.levelName.get(level));
    }

    private static final String color(String color, String s) {
        return color == null ? s : color + s + ANSI_RESET;
    }

    private static final String shortLoggerName(String loggerName) {
        return loggerName.substring(loggerName.lastIndexOf(".") + 1);
    }

    private static final String stackString(Throwable ex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
        ex.printStackTrace(pw);
        pw.flush();
        return baos.toString();
    }
}

