/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.console.log;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.jmatrix.console.log.ANSIColorFormatter;
import net.jmatrix.console.log.ColorConsoleLogger;
import net.jmatrix.console.log.ConsoleLogWriter;
import net.jmatrix.console.log.SimpleFormatter;
import org.slf4j.event.Level;

public class ColorConsoleConfig {
    public static final String ANSIColorFormatter = "ANSIColorFormatter";
    public static final String SimpleFormatter = "SimpleFormatter";
    static final List<String> validLevels = Arrays.asList("ERROR", "WARN", "INFO", "DEBUG", "TRACE");
    static final List<String> validStreams = Arrays.asList("out", "err");
    static final List<String> validFormatters = Arrays.asList("ANSIColorFormatter", "SimpleFormatter");

    public static void configure(Properties props) {
        String slevel = props.getProperty("slf.cc.level", "WARN");
        if (slevel != null && validLevels.contains(slevel = slevel.toUpperCase())) {
            ColorConsoleLogger.setGlobalLevel(Level.valueOf((String)slevel));
        }
        ConsoleLogWriter writer = (ConsoleLogWriter)ColorConsoleLogger.getWriter();
        String defStream = props.getProperty("slf.cc.writer.default.stream");
        if (defStream != null && validStreams.contains(defStream = defStream.toLowerCase())) {
            if (defStream.equals("out")) {
                writer.setDefaultStream(System.out);
            } else if (defStream.equals("err")) {
                writer.setDefaultStream(System.err);
            }
        }
        for (String vlevel : validLevels) {
            String streamName = props.getProperty("slf.cc.writer." + vlevel);
            if (streamName == null || !validStreams.contains(streamName)) continue;
            Level level = Level.valueOf((String)vlevel);
            if (streamName.equals("out")) {
                writer.setLevelStream(level, System.out);
                continue;
            }
            if (!streamName.equals("err")) continue;
            writer.setLevelStream(level, System.err);
        }
        String formatter = props.getProperty("slf.cc.formatter");
        if (formatter != null && validFormatters.contains(formatter)) {
            if (formatter.equals(ANSIColorFormatter)) {
                ColorConsoleLogger.setFormatter(new ANSIColorFormatter());
            } else if (formatter.equals(SimpleFormatter)) {
                ColorConsoleLogger.setFormatter(new SimpleFormatter());
            }
        }
    }
}

