/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.console.log;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import net.jmatrix.console.log.ANSIColorFormatter;
import net.jmatrix.console.log.ConsoleLogWriter;
import net.jmatrix.console.log.LevelMapper;
import net.jmatrix.console.log.LogWriter;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.slf4j.helpers.MarkerIgnoringBase;

public class ColorConsoleLogger
extends MarkerIgnoringBase
implements Logger {
    String name;
    Level ilevel = null;
    static Level level = Level.WARN;
    static LogWriter writer = null;
    static Formatter formatter = null;

    public ColorConsoleLogger(String name) {
        writer = new ConsoleLogWriter();
        formatter = new ANSIColorFormatter();
        this.name = name;
    }

    public static void setGlobalLevel(Level l) {
        level = l;
    }

    public static Level getGlobalLevel() {
        return level;
    }

    public static void setFormatter(Formatter f) {
        formatter = f;
    }

    public static Formatter getFormatter() {
        return formatter;
    }

    public static void setWriter(LogWriter w) {
        writer = w;
    }

    public static LogWriter getWriter() {
        return writer;
    }

    final void formatAndWrite(Level level, String message, Throwable t) {
        LogRecord lr = new LogRecord(LevelMapper.slfToJulLevel(level), message);
        lr.setMillis(System.currentTimeMillis());
        lr.setLoggerName(this.name);
        lr.setThrown(t);
        String formattedMessage = formatter.format(lr);
        writer.write(this.getLevel(), formattedMessage);
    }

    Level getLevel() {
        if (this.ilevel != null) {
            return this.ilevel;
        }
        return level;
    }

    public boolean isTraceEnabled() {
        return this.getLevel().toInt() <= Level.TRACE.toInt();
    }

    public void trace(String msg) {
        this.trace(msg, null);
    }

    public void trace(String format, Object arg) {
        this.trace(String.format(format, arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(String.format(format, arg1, arg2));
    }

    public void trace(String format, Object ... arguments) {
        this.trace(String.format(format, arguments));
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.formatAndWrite(Level.TRACE, msg, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.getLevel().toInt() <= Level.DEBUG.toInt();
    }

    public void debug(String msg) {
        this.debug(msg, null);
    }

    public void debug(String format, Object arg) {
        this.debug(String.format(format, arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(String.format(format, arg1, arg2));
    }

    public void debug(String format, Object ... arguments) {
        this.debug(String.format(format, arguments));
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.formatAndWrite(Level.DEBUG, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.getLevel().toInt() <= Level.INFO.toInt();
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(String format, Object arg) {
        this.info(String.format(format, arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(String.format(format, arg1, arg2));
    }

    public void info(String format, Object ... arguments) {
        this.info(String.format(format, arguments));
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.formatAndWrite(Level.INFO, msg, t);
        }
    }

    public boolean isWarnEnabled() {
        return this.getLevel().toInt() <= Level.WARN.toInt();
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String format, Object arg) {
        this.warn(String.format(format, arg));
    }

    public void warn(String format, Object ... arguments) {
        this.warn(String.format(format, arguments));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(String.format(format, arg1, arg2));
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.formatAndWrite(Level.WARN, msg, t);
        }
    }

    public boolean isErrorEnabled() {
        return this.getLevel().toInt() <= Level.ERROR.toInt();
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String format, Object arg) {
        this.error(String.format(format, arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(String.format(format, arg1, arg2));
    }

    public void error(String format, Object ... arguments) {
        this.error(String.format(format, arguments));
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.formatAndWrite(Level.ERROR, msg, t);
        }
    }
}

