/*
 * Decompiled with CFR 0.152.
 */
package net.jmatrix.console.log;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.jmatrix.console.log.LogWriter;
import org.slf4j.event.Level;

public class ConsoleLogWriter
implements LogWriter {
    PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
    PrintWriter err = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);
    Map<Level, PrintWriter> writerMap = new HashMap<Level, PrintWriter>();
    PrintWriter defaultWriter = this.out;

    public ConsoleLogWriter() {
        this.writerMap.put(Level.WARN, this.err);
        this.writerMap.put(Level.ERROR, this.err);
    }

    public void setLevelStream(Level level, PrintStream ps) {
        if (ps == System.out) {
            this.writerMap.put(level, this.out);
        }
        if (ps == System.err) {
            this.writerMap.put(level, this.err);
        }
    }

    public void setDefaultStream(PrintStream ps) {
        if (ps == System.out) {
            this.defaultWriter = this.out;
        } else if (ps == System.err) {
            this.defaultWriter = this.err;
        }
    }

    @Override
    public void write(Level level, String formattedMessage) {
        PrintWriter pw = this.writerMap.get(level);
        if (pw == null) {
            pw = this.defaultWriter;
        }
        pw.println(formattedMessage);
    }
}

