/*
 * Decompiled with CFR 0.152.
 */
package net.joningi.icndb;

import com.google.gson.GsonBuilder;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import net.joningi.icndb.CategoriesContainer;
import net.joningi.icndb.Container;
import net.joningi.icndb.CountContainer;
import net.joningi.icndb.MultiContainer;

public class APIService {
    public static final String BASE_URL = "http://api.icndb.com/";
    protected final Client client = ClientBuilder.newClient();

    private String request(String url) {
        try {
            WebTarget myResource = this.client.target(url);
            return (String)myResource.request(new String[]{"text/plain"}).get(String.class);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public Container get(String value) {
        return (Container)new GsonBuilder().create().fromJson(this.request(BASE_URL + value), Container.class);
    }

    public MultiContainer getMulti(String value) {
        return (MultiContainer)new GsonBuilder().create().fromJson(this.request(BASE_URL + value), MultiContainer.class);
    }

    public int getCount() {
        return ((CountContainer)new GsonBuilder().create().fromJson(this.request("http://api.icndb.com/jokes/count"), CountContainer.class)).getCount();
    }

    public List<String> getCategories() {
        return ((CategoriesContainer)new GsonBuilder().create().fromJson(this.request("http://api.icndb.com//categories"), CategoriesContainer.class)).getCategories();
    }
}

