/*
 * Decompiled with CFR 0.152.
 */
package net.joningi.icndb;

import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;

public class QueryString {
    private final Map<String, String> parameters = Maps.newHashMap();

    public void add(String key, String value) {
        this.parameters.put(key, value);
    }

    private String build() {
        StringBuilder builder = new StringBuilder();
        if (!this.parameters.isEmpty()) {
            builder.append("?");
        }
        Iterator<Map.Entry<String, String>> iterator = this.parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            builder.append(URLEncoder.encode(entry.getKey())).append('=').append(URLEncoder.encode(entry.getValue()));
            if (!iterator.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    public String toString() {
        return this.build();
    }

    public void addAll(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }
}

