/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.dfr;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import net.krotscheck.dfr.IDataDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecoderCache {
    private static Logger logger = LoggerFactory.getLogger(DecoderCache.class);
    private static Map<String, Class<? extends IDataDecoder>> cache;

    private DecoderCache() {
    }

    private static void populateCache() {
        if (cache == null) {
            cache = new LinkedHashMap<String, Class<? extends IDataDecoder>>();
            logger.info("IDataDecoders found:");
            ServiceLoader<IDataDecoder> loader = ServiceLoader.load(IDataDecoder.class);
            for (IDataDecoder discoveredDecoder : loader) {
                String name = discoveredDecoder.getClass().getCanonicalName();
                String decoderMimeType = discoveredDecoder.getMimeType();
                logger.info(String.format("    %s -> %s", decoderMimeType, name));
                cache.put(decoderMimeType, discoveredDecoder.getClass());
            }
        }
    }

    public static Set<String> supportedMimeTypes() {
        DecoderCache.populateCache();
        return cache.keySet();
    }

    public static Boolean isMimeTypeSupported(String mimeType) {
        DecoderCache.populateCache();
        return cache.containsKey(mimeType);
    }

    public static IDataDecoder getDecoder(String mimeType) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        DecoderCache.populateCache();
        if (!cache.containsKey(mimeType)) {
            throw new ClassNotFoundException(String.format("IDataDecoder for mimeType [%s] not found.", mimeType));
        }
        Class<? extends IDataDecoder> decoderClass = cache.get(mimeType);
        return decoderClass.newInstance();
    }
}

