/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.dfr;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import net.krotscheck.dfr.IDataEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncoderCache {
    private static Logger logger = LoggerFactory.getLogger(EncoderCache.class);
    private static Map<String, Class<? extends IDataEncoder>> cache;

    private EncoderCache() {
    }

    private static void populateCache() {
        if (cache == null) {
            cache = new LinkedHashMap<String, Class<? extends IDataEncoder>>();
            logger.info("IDataEncoders found:");
            ServiceLoader<IDataEncoder> loader = ServiceLoader.load(IDataEncoder.class);
            for (IDataEncoder discoveredDecoder : loader) {
                String name = discoveredDecoder.getClass().getCanonicalName();
                String encoderMimeType = discoveredDecoder.getMimeType();
                logger.info(String.format("    %s -> %s", encoderMimeType, name));
                cache.put(encoderMimeType, discoveredDecoder.getClass());
            }
        }
    }

    public static Set<String> supportedMimeTypes() {
        EncoderCache.populateCache();
        return cache.keySet();
    }

    public static Boolean isMimeTypeSupported(String mimeType) {
        EncoderCache.populateCache();
        return cache.containsKey(mimeType);
    }

    public static IDataEncoder getEncoder(String mimeType) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        EncoderCache.populateCache();
        if (!cache.containsKey(mimeType)) {
            throw new ClassNotFoundException(String.format("IDataEncoder for mimeType [%s] not found.", mimeType));
        }
        Class<? extends IDataEncoder> encoderClass = cache.get(mimeType);
        return encoderClass.newInstance();
    }
}

