/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.dfr.stream;

import java.io.IOException;
import java.io.InputStream;
import net.krotscheck.dfr.AbstractDataDecoder;
import net.krotscheck.dfr.stream.IStreamDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamDecoder
extends AbstractDataDecoder
implements IStreamDecoder {
    private static Logger logger = LoggerFactory.getLogger(AbstractStreamDecoder.class);
    private InputStream inputStream;

    @Override
    public final InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public final void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    @Override
    public final void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException ioe) {
                logger.error("Unable to close output stream.", (Throwable)ioe);
            }
            finally {
                this.inputStream = null;
            }
        }
        this.dispose();
    }

    protected abstract void dispose();
}

