/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.dfr.text;

import java.io.IOException;
import java.io.Writer;
import net.krotscheck.dfr.AbstractDataEncoder;
import net.krotscheck.dfr.text.ITextEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextEncoder
extends AbstractDataEncoder
implements ITextEncoder {
    private static Logger logger = LoggerFactory.getLogger(AbstractTextEncoder.class);
    private Writer outputWriter;

    @Override
    public final Writer getWriter() {
        return this.outputWriter;
    }

    @Override
    public final void setWriter(Writer writer) {
        this.outputWriter = writer;
    }

    @Override
    public final void close() {
        this.dispose();
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
            }
            catch (IOException ioe) {
                logger.error("Unable to close output stream.", (Throwable)ioe);
            }
            finally {
                this.outputWriter = null;
            }
        }
    }

    protected abstract void dispose();
}

