/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.dfr;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.krotscheck.dfr.AbstractFilteredDataStream;
import net.krotscheck.dfr.IDataDecoder;
import net.krotscheck.dfr.IDataFilter;

public abstract class AbstractDataDecoder
extends AbstractFilteredDataStream
implements IDataDecoder {
    private Long maxRows;

    @Override
    public final Iterator<Map<String, Object>> iterator() {
        return new FilteredIterator(this.buildIterator(), this.getFilters(), this.maxRows);
    }

    protected abstract Iterator<Map<String, Object>> buildIterator();

    @Override
    public final Long getMaxRows() {
        return this.maxRows;
    }

    @Override
    public final void setMaxRows(Long rows) {
        this.maxRows = rows;
    }

    private static final class FilteredIterator
    implements Iterator<Map<String, Object>> {
        private final List<IDataFilter> filters;
        private final Iterator<Map<String, Object>> iterator;
        private final Long rows;
        private Long currentRow = 0L;

        public FilteredIterator(Iterator<Map<String, Object>> itr, List<IDataFilter> fltrs, Long maxRows) {
            this.iterator = itr;
            this.filters = fltrs;
            this.rows = maxRows;
        }

        @Override
        public boolean hasNext() {
            if (this.rows == null || this.currentRow < this.rows) {
                return this.iterator.hasNext();
            }
            return false;
        }

        @Override
        public Map<String, Object> next() {
            if (this.rows != null && this.currentRow >= this.rows) {
                return null;
            }
            Map<String, Object> row = this.iterator.next();
            for (IDataFilter filter : this.filters) {
                row = filter.apply(row);
            }
            Long l = this.currentRow;
            Long l2 = this.currentRow = Long.valueOf(this.currentRow + 1L);
            return row;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

