/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.dfr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.krotscheck.dfr.IDataFilter;
import net.krotscheck.dfr.IFilteringDataStream;

public abstract class AbstractFilteredDataStream
implements IFilteringDataStream {
    private List<IDataFilter> filters;

    private void assertFilterListExists() {
        if (this.filters == null) {
            this.filters = new ArrayList<IDataFilter>();
        }
    }

    @Override
    public final void addFilter(IDataFilter filter) {
        this.assertFilterListExists();
        if (!this.containsFilter(filter).booleanValue()) {
            this.filters.add(filter);
        }
    }

    @Override
    public final void addFilters(List<IDataFilter> newFilters) {
        this.assertFilterListExists();
        for (IDataFilter filter : newFilters) {
            this.addFilter(filter);
        }
    }

    @Override
    public final List<IDataFilter> getFilters() {
        this.assertFilterListExists();
        return Collections.unmodifiableList(this.filters);
    }

    @Override
    public final Boolean containsFilter(IDataFilter filter) {
        this.assertFilterListExists();
        return this.filters.contains(filter);
    }

    @Override
    public final void removeFilter(IDataFilter filter) {
        if (this.containsFilter(filter).booleanValue()) {
            this.filters.remove(filter);
        }
    }

    @Override
    public final void clearFilters() {
        if (this.filters != null) {
            this.filters = null;
        }
    }

    @Override
    public final Map<String, Object> applyFilters(Map<String, Object> row) {
        Map<String, Object> filteringRow = new LinkedHashMap<String, Object>(row);
        this.assertFilterListExists();
        for (IDataFilter filter : this.getFilters()) {
            filteringRow = filter.apply(filteringRow);
        }
        return filteringRow;
    }
}

