/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.dfr;

import java.io.IOException;
import java.util.Map;
import net.krotscheck.dfr.AbstractFilteredDataStream;
import net.krotscheck.dfr.IDataDecoder;
import net.krotscheck.dfr.IDataEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileStreamConverter
extends AbstractFilteredDataStream
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(FileStreamConverter.class);
    private IDataEncoder dataEncoder;
    private IDataDecoder dataDecoder;

    public FileStreamConverter(IDataDecoder decoder, IDataEncoder encoder) {
        if (decoder == null) {
            throw new RuntimeException("Data decoder is null");
        }
        if (encoder == null) {
            throw new RuntimeException("Data encoder is null");
        }
        this.dataEncoder = encoder;
        this.dataDecoder = decoder;
    }

    @Override
    public void run() {
        try {
            for (Map row : this.dataDecoder) {
                this.dataEncoder.write(this.applyFilters(row));
            }
            this.dataDecoder.close();
            this.dataEncoder.close();
        }
        catch (IOException ioe) {
            logger.error("Unable to complete conversion.", (Throwable)ioe);
        }
    }
}

