/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.dfr.stream;

import java.io.IOException;
import java.io.OutputStream;
import net.krotscheck.dfr.AbstractDataEncoder;
import net.krotscheck.dfr.stream.IStreamEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamEncoder
extends AbstractDataEncoder
implements IStreamEncoder {
    private static Logger logger = LoggerFactory.getLogger(AbstractStreamEncoder.class);
    private OutputStream outputStream;

    @Override
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public final void setOutputStream(OutputStream stream) {
        this.outputStream = stream;
    }

    @Override
    public final void close() {
        this.dispose();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException ioe) {
                logger.error("Unable to close output stream.", (Throwable)ioe);
            }
            finally {
                this.outputStream = null;
            }
        }
    }

    protected abstract void dispose();
}

