/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.data.mysql;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import net.kut3.data.DbClient;
import net.kut3.data.DbClientBuilder;
import net.kut3.data.InitializationException;

public final class MySqlClient
extends DbClient {
    private final HikariDataSource ds;

    public MySqlClient(DbClientBuilder builder) {
        super(builder);
        HikariDataSource tmpDs = new HikariDataSource();
        tmpDs.setJdbcUrl(builder.url());
        tmpDs.setConnectionTimeout((long)builder.connectionTimeout());
        if (null != builder.user()) {
            tmpDs.setUsername(builder.user());
            if (null == builder.pwd()) {
                throw new InitializationException("pwd is null");
            }
            tmpDs.setPassword(new String(builder.pwd()));
        }
        try {
            Connection conn = tmpDs.getConnection();
            Throwable throwable = null;
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new InitializationException(sqlEx.getMessage() == null ? "Connect to '" + builder.url() + "' by user '" + builder.user() + "' failed by unknown error" : sqlEx.getMessage().replace("\n", ""));
        }
        this.ds = tmpDs;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.ds.getConnection();
        conn.setAutoCommit(this.info.autoCommit());
        return conn;
    }

    public void close() {
        if (null != this.ds) {
            this.ds.close();
        }
    }
}

