/*
 * Decompiled with CFR 0.152.
 */
package gsonpath.generator.adapter;

import com.google.gson.JsonElement;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b\u001a\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0011\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011\u001a\u0012\u0010\u0019\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0011\u001a\n\u0010\u001b\u001a\u00020\u0017*\u00020\u0017\u001a+\u0010\u001c\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00112\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001f\u00a2\u0006\u0002\u0010 \"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u001f\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\b0\b0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"CLASS_NAME_JSON_ELEMENT", "Lcom/squareup/javapoet/ClassName;", "getCLASS_NAME_JSON_ELEMENT", "()Lcom/squareup/javapoet/ClassName;", "CLASS_NAME_STRING", "getCLASS_NAME_STRING", "GSON_SUPPORTED_CLASSES", "", "Lcom/squareup/javapoet/TypeName;", "getGSON_SUPPORTED_CLASSES", "()Ljava/util/Set;", "GSON_SUPPORTED_PRIMITIVE", "Ljava/util/HashSet;", "kotlin.jvm.PlatformType", "getGSON_SUPPORTED_PRIMITIVE", "()Ljava/util/HashSet;", "createDefaultVariableValueForTypeName", "", "typeName", "generateClassName", "className", "classNameSuffix", "addComment", "Lcom/squareup/javapoet/CodeBlock$Builder;", "comment", "addEscapedStatement", "format", "addNewLine", "addWithNewLine", "args", "", "", "(Lcom/squareup/javapoet/CodeBlock$Builder;Ljava/lang/String;[Ljava/lang/Object;)Lcom/squareup/javapoet/CodeBlock$Builder;", "gsonpath-compiler_main"})
public final class SharedFunctionsKt {
    @NotNull
    private static final Set<TypeName> GSON_SUPPORTED_CLASSES = new HashSet(Arrays.asList(TypeName.get((Type)Boolean.TYPE).box(), TypeName.get((Type)Integer.TYPE).box(), TypeName.get((Type)Long.TYPE).box(), TypeName.get((Type)Double.TYPE).box(), TypeName.get((Type)((Type)((Object)String.class))).box()));
    @NotNull
    private static final HashSet<TypeName> GSON_SUPPORTED_PRIMITIVE = new HashSet(Arrays.asList(TypeName.BOOLEAN, TypeName.INT, TypeName.LONG, TypeName.DOUBLE));
    @NotNull
    private static final ClassName CLASS_NAME_JSON_ELEMENT;
    @NotNull
    private static final ClassName CLASS_NAME_STRING;

    @NotNull
    public static final Set<TypeName> getGSON_SUPPORTED_CLASSES() {
        return GSON_SUPPORTED_CLASSES;
    }

    @NotNull
    public static final HashSet<TypeName> getGSON_SUPPORTED_PRIMITIVE() {
        return GSON_SUPPORTED_PRIMITIVE;
    }

    @NotNull
    public static final ClassName getCLASS_NAME_JSON_ELEMENT() {
        return CLASS_NAME_JSON_ELEMENT;
    }

    @NotNull
    public static final ClassName getCLASS_NAME_STRING() {
        return CLASS_NAME_STRING;
    }

    @NotNull
    public static final String createDefaultVariableValueForTypeName(@NotNull TypeName typeName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        TypeName typeName2 = typeName;
        if (Intrinsics.areEqual((Object)typeName2, (Object)TypeName.INT) || Intrinsics.areEqual((Object)typeName2, (Object)TypeName.BYTE) || Intrinsics.areEqual((Object)typeName2, (Object)TypeName.SHORT)) {
            return "0";
        }
        if (Intrinsics.areEqual((Object)typeName2, (Object)TypeName.LONG)) {
            return "0L";
        }
        if (Intrinsics.areEqual((Object)typeName2, (Object)TypeName.FLOAT)) {
            return "0f";
        }
        if (Intrinsics.areEqual((Object)typeName2, (Object)TypeName.DOUBLE)) {
            return "0d";
        }
        if (Intrinsics.areEqual((Object)typeName2, (Object)TypeName.CHAR)) {
            return "'\\u0000'";
        }
        if (Intrinsics.areEqual((Object)typeName2, (Object)TypeName.BOOLEAN)) {
            return "false";
        }
        return "null";
    }

    @NotNull
    public static final String generateClassName(@NotNull ClassName className, @NotNull String classNameSuffix) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)classNameSuffix, (String)"classNameSuffix");
        String fileName = "";
        for (String name : className.simpleNames()) {
            fileName = fileName + name + "_";
        }
        return StringsKt.replace$default((String)fileName, (String)".", (String)"_", (boolean)false, (int)4, null) + classNameSuffix;
    }

    @NotNull
    public static final CodeBlock.Builder addWithNewLine(@NotNull CodeBlock.Builder $receiver, @NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        $receiver.add(format, Arrays.copyOf(args, args.length));
        SharedFunctionsKt.addNewLine($receiver);
        return $receiver;
    }

    @NotNull
    public static final CodeBlock.Builder addNewLine(@NotNull CodeBlock.Builder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.add("\n", new Object[0]);
        return $receiver;
    }

    @NotNull
    public static final CodeBlock.Builder addComment(@NotNull CodeBlock.Builder $receiver, @NotNull String comment) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        $receiver.add("// " + comment + "\n", new Object[0]);
        return $receiver;
    }

    @NotNull
    public static final CodeBlock.Builder addEscapedStatement(@NotNull CodeBlock.Builder $receiver, @NotNull String format) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        $receiver.addStatement(StringsKt.replace$default((String)format, (String)"$", (String)"$$", (boolean)false, (int)4, null), new Object[0]);
        return $receiver;
    }

    static {
        ClassName className = ClassName.get(JsonElement.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"ClassName.get(JsonElement::class.java)");
        CLASS_NAME_JSON_ELEMENT = className;
        ClassName className2 = ClassName.get(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)className2, (String)"ClassName.get(String::class.java)");
        CLASS_NAME_STRING = className2;
    }
}

