/*
 * Decompiled with CFR 0.152.
 */
package gsonpath.generator.adapter.standard;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import gsonpath.AutoGsonAdapter;
import gsonpath.GsonPathDefaultConfiguration;
import gsonpath.GsonUtil;
import gsonpath.ProcessingException;
import gsonpath.generator.Generator;
import gsonpath.generator.HandleResult;
import gsonpath.generator.adapter.SharedFunctionsKt;
import gsonpath.generator.adapter.interf.ModelInterfaceGenerator;
import gsonpath.generator.adapter.standard.AutoGsonAdapterProperties;
import gsonpath.generator.adapter.standard.AutoGsonAdapterPropertiesFactory;
import gsonpath.generator.adapter.standard.ReadFunctionsKt;
import gsonpath.generator.adapter.standard.WriteFunctionsKt;
import gsonpath.model.FieldInfo;
import gsonpath.model.FieldInfoFactory;
import gsonpath.model.GsonObject;
import gsonpath.model.GsonObjectTreeFactory;
import gsonpath.model.InterfaceInfo;
import gsonpath.model.MandatoryFieldInfo;
import gsonpath.model.MandatoryFieldInfoFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lgsonpath/generator/adapter/standard/AutoGsonAdapterGenerator;", "Lgsonpath/generator/Generator;", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "getDefaultsAnnotation", "Lgsonpath/GsonPathDefaultConfiguration;", "autoGsonAnnotation", "Lgsonpath/AutoGsonAdapter;", "handle", "Lgsonpath/generator/HandleResult;", "modelElement", "Ljavax/lang/model/element/TypeElement;", "onJavaFileBuilt", "", "builder", "Lcom/squareup/javapoet/JavaFile$Builder;", "gsonpath-compiler_main"})
public final class AutoGsonAdapterGenerator
extends Generator {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HandleResult handle(@NotNull TypeElement modelElement) throws ProcessingException {
        List<FieldInfo> fieldInfoList;
        ClassName concreteClassName;
        Intrinsics.checkParameterIsNotNull((Object)modelElement, (String)"modelElement");
        ClassName modelClassName = ClassName.get((TypeElement)modelElement);
        String string = modelClassName.packageName();
        ClassName className = modelClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"modelClassName");
        ClassName adapterClassName = ClassName.get((String)string, (String)SharedFunctionsKt.generateClassName(className, "GsonTypeAdapter"), (String[])new String[0]);
        TypeSpec.Builder adapterTypeBuilder = TypeSpec.classBuilder((ClassName)adapterClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeAdapter.class), (TypeName[])new TypeName[]{(TypeName)modelClassName})).addField((Type)((Object)Gson.class), "mGson", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        adapterTypeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((Type)((Object)Gson.class), "gson", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"mGson", "gson"}).build());
        AutoGsonAdapter autoGsonAnnotation = modelElement.getAnnotation(AutoGsonAdapter.class);
        boolean isModelInterface = modelElement.getKind().isInterface();
        AutoGsonAdapterPropertiesFactory autoGsonAdapterPropertiesFactory = new AutoGsonAdapterPropertiesFactory();
        AutoGsonAdapter autoGsonAdapter = autoGsonAnnotation;
        Intrinsics.checkExpressionValueIsNotNull((Object)autoGsonAdapter, (String)"autoGsonAnnotation");
        AutoGsonAdapter autoGsonAdapter2 = autoGsonAnnotation;
        Intrinsics.checkExpressionValueIsNotNull((Object)autoGsonAdapter2, (String)"autoGsonAnnotation");
        AutoGsonAdapterProperties properties = autoGsonAdapterPropertiesFactory.create(autoGsonAdapter, this.getDefaultsAnnotation(autoGsonAdapter2), isModelInterface);
        FieldInfoFactory fieldInfoFactory = new FieldInfoFactory(this.getProcessingEnv());
        if (!isModelInterface) {
            ClassName className2 = modelClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)className2, (String)"modelClassName");
            concreteClassName = className2;
            fieldInfoList = fieldInfoFactory.getModelFieldsFromElement(modelElement, properties.getFieldsRequireAnnotation());
        } else {
            InterfaceInfo interfaceInfo = new ModelInterfaceGenerator(this.getProcessingEnv()).handle(modelElement);
            concreteClassName = interfaceInfo.getParentClassName();
            fieldInfoList = fieldInfoFactory.getModelFieldsFromInterface(interfaceInfo);
        }
        GsonObject rootGsonObject = new GsonObjectTreeFactory().createGsonObject(fieldInfoList, properties.getRootField(), properties.getFlattenDelimiter(), properties.getGsonFieldNamingPolicy(), properties.getGsonFieldValidationType(), properties.getPathSubstitutions());
        Map<String, MandatoryFieldInfo> mandatoryInfoMap = new MandatoryFieldInfoFactory().createMandatoryFieldsFromGsonObject(rootGsonObject);
        Object object = mandatoryInfoMap;
        if (!object.isEmpty()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            object = mandatoryInfoMap.values();
            Iterator iterator = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void mandatoryIndex;
                void mandatoryField;
                int n = index$iv$iv++;
                MandatoryFieldInfo mandatoryFieldInfo = (MandatoryFieldInfo)item$iv$iv;
                int n2 = n;
                void var24_22 = destination$iv$iv;
                FieldSpec fieldSpec = FieldSpec.builder((TypeName)TypeName.INT, (String)mandatoryField.getIndexVariableName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("" + (int)mandatoryIndex, new Object[0]).build();
                var24_22.add(fieldSpec);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                FieldSpec it = (FieldSpec)element$iv;
                adapterTypeBuilder.addField(it);
            }
            adapterTypeBuilder.addField(FieldSpec.builder((TypeName)TypeName.INT, (String)"MANDATORY_FIELDS_SIZE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("" + mandatoryInfoMap.size(), new Object[0]).build());
        }
        ClassName className3 = modelClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)className3, (String)"modelClassName");
        adapterTypeBuilder.addMethod(ReadFunctionsKt.createReadMethod(className3, concreteClassName, mandatoryInfoMap, rootGsonObject));
        if (!isModelInterface) {
            ClassName className4 = modelClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)className4, (String)"modelClassName");
            adapterTypeBuilder.addMethod(WriteFunctionsKt.createWriteMethod(className4, rootGsonObject, properties.getSerializeNulls()));
        } else {
            MethodSpec.Builder writeMethod = MethodSpec.methodBuilder((String)"write").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((Type)((Object)JsonWriter.class), "out", new Modifier[0]).addParameter((TypeName)modelClassName, "value", new Modifier[0]).addException((Type)((Object)IOException.class));
            adapterTypeBuilder.addMethod(writeMethod.build());
        }
        String string2 = adapterClassName.packageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"adapterClassName.packageName()");
        TypeSpec.Builder builder = adapterTypeBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"adapterTypeBuilder");
        if (this.writeFile(string2, builder)) {
            ClassName className5 = modelClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)className5, (String)"modelClassName");
            ClassName className6 = adapterClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)className6, (String)"adapterClassName");
            return new HandleResult(className5, className6);
        }
        throw (Throwable)new ProcessingException("Failed to write generated file: " + adapterClassName.simpleName(), null, 2, null);
    }

    @Override
    public void onJavaFileBuilt(@NotNull JavaFile.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.addStaticImport(GsonUtil.class, new String[]{"*"});
    }

    private final GsonPathDefaultConfiguration getDefaultsAnnotation(AutoGsonAdapter autoGsonAnnotation) throws ProcessingException {
        TypeMirror defaultsTypeMirror = null;
        try {
            autoGsonAnnotation.defaultConfiguration();
        }
        catch (MirroredTypeException mte) {
            defaultsTypeMirror = mte.getTypeMirror();
        }
        Element defaultsElement = this.getProcessingEnv().getTypeUtils().asElement(defaultsTypeMirror);
        GsonPathDefaultConfiguration defaultsAnnotation = null;
        if (defaultsElement != null && (defaultsAnnotation = defaultsElement.getAnnotation(GsonPathDefaultConfiguration.class)) == null) {
            throw (Throwable)new ProcessingException("Defaults property must point to a class which uses the @GsonPathDefaultConfiguration annotation", null, 2, null);
        }
        return defaultsAnnotation;
    }

    public AutoGsonAdapterGenerator(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnv, (String)"processingEnv");
        super(processingEnv);
    }
}

