/*
 * Decompiled with CFR 0.152.
 */
package gsonpath.generator.adapter.standard;

import com.google.gson.stream.JsonReader;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import gsonpath.FlattenJson;
import gsonpath.ProcessingException;
import gsonpath.generator.adapter.standard.FieldReaderResult;
import gsonpath.generator.adapter.standard.SharedFunctionsKt;
import gsonpath.model.FieldInfo;
import gsonpath.model.GsonField;
import gsonpath.model.GsonObject;
import gsonpath.model.GsonObjectTreeFactory;
import gsonpath.model.MandatoryFieldInfo;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u001a>\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u000bH\u0003\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u001a4\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0016\u001a\u00020\rH\u0007\u001a\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a*\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0003\u001a \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006 "}, d2={"addMandatoryValuesCheck", "", "codeBlock", "Lcom/squareup/javapoet/CodeBlock$Builder;", "mandatoryInfoMap", "", "", "Lgsonpath/model/MandatoryFieldInfo;", "concreteElement", "Lcom/squareup/javapoet/ClassName;", "addReadCodeForElements", "", "jsonMapping", "Lgsonpath/model/GsonObject;", "requiresConstructorInjection", "", "recursionCount", "addValidValueCheck", "addReturn", "createReadMethod", "Lcom/squareup/javapoet/MethodSpec;", "baseElement", "rootElements", "getVariableName", "gsonField", "Lgsonpath/model/GsonField;", "isCheckIfNullApplicable", "writeGsonFieldReader", "mandatoryFieldInfo", "writeGsonFieldReaderSupported", "Lgsonpath/generator/adapter/standard/FieldReaderResult;", "writeGsonFieldReaderUnsupported", "gsonpath-compiler_main"})
public final class ReadFunctionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MethodSpec createReadMethod(@NotNull ClassName baseElement, @NotNull ClassName concreteElement, @NotNull Map<String, MandatoryFieldInfo> mandatoryInfoMap, @NotNull GsonObject rootElements) throws ProcessingException {
        Intrinsics.checkParameterIsNotNull((Object)baseElement, (String)"baseElement");
        Intrinsics.checkParameterIsNotNull((Object)concreteElement, (String)"concreteElement");
        Intrinsics.checkParameterIsNotNull(mandatoryInfoMap, (String)"mandatoryInfoMap");
        Intrinsics.checkParameterIsNotNull((Object)rootElements, (String)"rootElements");
        List<GsonField> flattenedFields = new GsonObjectTreeFactory().getFlattenedFieldsFromGsonObject(rootElements);
        MethodSpec.Builder readMethod = MethodSpec.methodBuilder((String)"read").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)baseElement).addParameter((Type)((Object)JsonReader.class), "in", new Modifier[0]).addException((Type)((Object)IOException.class));
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        boolean requiresConstructorInjection = Intrinsics.areEqual((Object)baseElement, (Object)concreteElement) ^ true;
        CodeBlock.Builder builder = codeBlock;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"codeBlock");
        ReadFunctionsKt.addValidValueCheck(builder, true);
        if (!requiresConstructorInjection) {
            codeBlock.addStatement("$T result = new $T()", new Object[]{concreteElement, concreteElement});
        } else {
            for (GsonField gsonField : flattenedFields) {
                TypeName typeName = gsonField.getFieldInfo().getTypeName();
                String defaultValue = gsonpath.generator.adapter.SharedFunctionsKt.createDefaultVariableValueForTypeName(typeName);
                codeBlock.addStatement(typeName + " " + gsonField.getVariableName() + " = " + defaultValue, new Object[0]);
            }
        }
        Map<String, MandatoryFieldInfo> map2 = mandatoryInfoMap;
        if (!map2.isEmpty()) {
            codeBlock.addStatement("boolean[] mandatoryFieldsCheckList = new boolean[MANDATORY_FIELDS_SIZE]", new Object[0]);
        }
        gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock);
        CodeBlock.Builder builder2 = codeBlock;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"codeBlock");
        ReadFunctionsKt.addReadCodeForElements$default(builder2, rootElements, requiresConstructorInjection, mandatoryInfoMap, 0, 16, null);
        CodeBlock.Builder builder3 = codeBlock;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"codeBlock");
        ReadFunctionsKt.addMandatoryValuesCheck(builder3, mandatoryInfoMap, concreteElement);
        if (!requiresConstructorInjection) {
            codeBlock.addStatement("return result", new Object[0]);
        } else {
            CodeBlock.Builder builder4 = gsonpath.generator.adapter.SharedFunctionsKt.addWithNewLine(CodeBlock.builder(), "return new $T(", concreteElement).indent();
            int n = 0;
            int n2 = ((Collection)flattenedFields).size() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    builder4.add(flattenedFields.get((int)i).getVariableName(), new Object[0]);
                    if (i < flattenedFields.size() - 1) {
                        builder4.add(",", new Object[0]);
                    }
                    gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(builder4);
                    if (i == n2) break;
                    ++i;
                }
            }
            codeBlock.add(builder4.unindent().addStatement(")", new Object[0]).build());
        }
        MethodSpec methodSpec = readMethod.addCode(codeBlock.build()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"readMethod.addCode(codeB\u2026d())\n            .build()");
        return methodSpec;
    }

    private static final int addReadCodeForElements(CodeBlock.Builder codeBlock, GsonObject jsonMapping, boolean requiresConstructorInjection, Map<String, MandatoryFieldInfo> mandatoryInfoMap, int recursionCount) throws ProcessingException {
        Object value;
        int jsonMappingSize = jsonMapping.size();
        if (jsonMappingSize == 0) {
            return recursionCount;
        }
        if (jsonMappingSize == 1 && (value = jsonMapping.get(jsonMapping.keySet().iterator().next())) instanceof GsonField && ((GsonField)value).getFieldInfo().isDirectAccess()) {
            ReadFunctionsKt.writeGsonFieldReader((GsonField)value, codeBlock, requiresConstructorInjection, mandatoryInfoMap.get(((GsonField)value).getFieldInfo().getFieldName()));
            return recursionCount + 1;
        }
        String counterVariableName = "jsonFieldCounter" + recursionCount;
        int newRecursionCount = recursionCount + 1;
        gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock.addStatement("int " + counterVariableName + " = 0", new Object[0]).addStatement("in.beginObject()", new Object[0])).beginControlFlow("while (in.hasNext())", new Object[0]).beginControlFlow("if (" + counterVariableName + " == " + jsonMappingSize + ")", new Object[0]).addStatement("in.skipValue()", new Object[0]).addStatement("continue", new Object[0]).endControlFlow()).beginControlFlow("switch (in.nextName())", new Object[0]);
        for (String key : jsonMapping.keySet()) {
            gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock.add("case " + "\"" + key + "\"" + ":", new Object[0])).indent().addStatement(counterVariableName + "++", new Object[0]);
            Object value2 = jsonMapping.get(key);
            if (value2 instanceof GsonField) {
                ReadFunctionsKt.writeGsonFieldReader((GsonField)value2, codeBlock, requiresConstructorInjection, mandatoryInfoMap.get(((GsonField)value2).getFieldInfo().getFieldName()));
            } else if (value2 instanceof GsonObject) {
                gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock);
                ReadFunctionsKt.addValidValueCheck(codeBlock, false);
                newRecursionCount = ReadFunctionsKt.addReadCodeForElements(codeBlock, (GsonObject)value2, requiresConstructorInjection, mandatoryInfoMap, newRecursionCount);
            }
            gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock.addStatement("break", new Object[0])).unindent();
        }
        gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(gsonpath.generator.adapter.SharedFunctionsKt.addWithNewLine(codeBlock, "default:", new Object[0]).indent().addStatement("in.skipValue()", new Object[0]).addStatement("break", new Object[0]).unindent().endControlFlow().endControlFlow()).addStatement("in.endObject()", new Object[0]);
        return newRecursionCount;
    }

    static /* bridge */ /* synthetic */ int addReadCodeForElements$default(CodeBlock.Builder builder, GsonObject gsonObject, boolean bl, Map map2, int n, int n2, Object object) throws ProcessingException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addReadCodeForElements");
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return ReadFunctionsKt.addReadCodeForElements(builder, gsonObject, bl, map2, n);
    }

    private static final void writeGsonFieldReader(GsonField gsonField, CodeBlock.Builder codeBlock, boolean requiresConstructorInjection, MandatoryFieldInfo mandatoryFieldInfo) throws ProcessingException {
        FieldReaderResult result;
        FieldInfo fieldInfo2 = gsonField.getFieldInfo();
        SharedFunctionsKt.validateFieldAnnotations(fieldInfo2);
        TypeName fieldTypeName = fieldInfo2.getTypeName();
        if (fieldTypeName.isPrimitive() && !gsonpath.generator.adapter.SharedFunctionsKt.getGSON_SUPPORTED_PRIMITIVE().contains(fieldTypeName)) {
            throw (Throwable)new ProcessingException("Unsupported primitive type found. Only boolean, int, double and long can be used.", fieldInfo2.getElement());
        }
        gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock);
        FieldReaderResult fieldReaderResult = result = gsonpath.generator.adapter.SharedFunctionsKt.getGSON_SUPPORTED_CLASSES().contains(fieldTypeName.box()) ? ReadFunctionsKt.writeGsonFieldReaderSupported(codeBlock, gsonField, requiresConstructorInjection) : ReadFunctionsKt.writeGsonFieldReaderUnsupported(codeBlock, gsonField, requiresConstructorInjection);
        if (result.getCheckIfNull()) {
            codeBlock.beginControlFlow("if (" + result.getVariableName() + " != null)", new Object[0]);
            String assignmentBlock = !requiresConstructorInjection ? "result." + fieldInfo2.getFieldName() : gsonField.getVariableName();
            codeBlock.addStatement(assignmentBlock + " = " + result.getVariableName() + (result.getCallToString() ? ".toString()" : ""), new Object[0]);
            if (mandatoryFieldInfo != null) {
                gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock.addStatement("mandatoryFieldsCheckList[" + mandatoryFieldInfo.getIndexVariableName() + "] = true", new Object[0]));
            }
            if (gsonField.isRequired()) {
                gsonpath.generator.adapter.SharedFunctionsKt.addEscapedStatement(codeBlock.nextControlFlow("else", new Object[0]), "throw new gsonpath.JsonFieldMissingException(" + "\"" + "Mandatory JSON element '" + gsonField.getJsonPath() + "' was null for class '" + fieldInfo2.getParentClassName() + "'" + "\"" + ")");
            }
            codeBlock.endControlFlow();
        }
    }

    private static final String getVariableName(GsonField gsonField, boolean requiresConstructorInjection) {
        return gsonField.isRequired() && requiresConstructorInjection ? gsonField.getVariableName() + "_safe" : gsonField.getVariableName();
    }

    private static final boolean isCheckIfNullApplicable(GsonField gsonField, boolean requiresConstructorInjection) {
        return !requiresConstructorInjection || gsonField.isRequired();
    }

    private static final FieldReaderResult writeGsonFieldReaderSupported(CodeBlock.Builder codeBlock, GsonField gsonField, boolean requiresConstructorInjection) {
        FlattenJson annotation;
        FieldInfo fieldInfo2 = gsonField.getFieldInfo();
        if (Intrinsics.areEqual((Object)fieldInfo2.getTypeName(), (Object)gsonpath.generator.adapter.SharedFunctionsKt.getCLASS_NAME_STRING()) && (annotation = fieldInfo2.getAnnotation(FlattenJson.class)) != null) {
            String variableName = requiresConstructorInjection ? gsonField.getVariableName() + "_safe" : gsonField.getVariableName();
            codeBlock.addStatement("$" + "T " + variableName + " = mGson.getAdapter(" + "$" + "T.class).read(in)", new Object[]{gsonpath.generator.adapter.SharedFunctionsKt.getCLASS_NAME_JSON_ELEMENT(), gsonpath.generator.adapter.SharedFunctionsKt.getCLASS_NAME_JSON_ELEMENT()});
            return new FieldReaderResult(variableName, true, true);
        }
        String variableName = ReadFunctionsKt.getVariableName(gsonField, requiresConstructorInjection);
        boolean checkIfResultIsNull = ReadFunctionsKt.isCheckIfNullApplicable(gsonField, requiresConstructorInjection);
        TypeName typeName = fieldInfo2.getTypeName().box();
        if (typeName == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        ClassName fieldClassName = (ClassName)typeName;
        String variableAssignment = variableName + " = get" + fieldClassName.simpleName() + "Safely(in)";
        if (checkIfResultIsNull) {
            codeBlock.addStatement(fieldClassName.simpleName() + " " + variableAssignment, new Object[0]);
        } else {
            codeBlock.addStatement(variableAssignment, new Object[0]);
        }
        return new FieldReaderResult(variableName, checkIfResultIsNull, false, 4, null);
    }

    private static final FieldReaderResult writeGsonFieldReaderUnsupported(CodeBlock.Builder codeBlock, GsonField gsonField, boolean requiresConstructorInjection) {
        TypeName fieldTypeName = gsonField.getFieldInfo().getTypeName();
        String adapterName = fieldTypeName instanceof ParameterizedTypeName ? "new com.google.gson.reflect.TypeToken<" + fieldTypeName + ">(){}" : fieldTypeName.toString() + ".class";
        String variableName = ReadFunctionsKt.getVariableName(gsonField, requiresConstructorInjection);
        boolean checkIfResultIsNull = ReadFunctionsKt.isCheckIfNullApplicable(gsonField, requiresConstructorInjection);
        String variableAssignment = variableName + " = mGson.getAdapter(" + adapterName + ").read(in)";
        if (checkIfResultIsNull) {
            codeBlock.addStatement(fieldTypeName + " " + variableAssignment, new Object[0]);
        } else {
            codeBlock.addStatement(variableAssignment, new Object[0]);
        }
        return new FieldReaderResult(variableName, checkIfResultIsNull, false, 4, null);
    }

    private static final void addMandatoryValuesCheck(CodeBlock.Builder codeBlock, Map<String, MandatoryFieldInfo> mandatoryInfoMap, ClassName concreteElement) {
        if (mandatoryInfoMap.isEmpty()) {
            return;
        }
        gsonpath.generator.adapter.SharedFunctionsKt.addComment(gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(gsonpath.generator.adapter.SharedFunctionsKt.addComment(gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(gsonpath.generator.adapter.SharedFunctionsKt.addComment(gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock), "Mandatory object validation").beginControlFlow("for (int mandatoryFieldIndex = 0; mandatoryFieldIndex < MANDATORY_FIELDS_SIZE; mandatoryFieldIndex++)", new Object[0])), "Check if a mandatory value is missing.").beginControlFlow("if (!mandatoryFieldsCheckList[mandatoryFieldIndex])", new Object[0])), "Find the field name of the missing json value.").addStatement("String fieldName = null", new Object[0]).beginControlFlow("switch (mandatoryFieldIndex)", new Object[0]);
        Map<String, MandatoryFieldInfo> map2 = mandatoryInfoMap;
        Iterator<Map.Entry<String, MandatoryFieldInfo>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MandatoryFieldInfo> entry;
            Map.Entry<String, MandatoryFieldInfo> entry2 = entry = iterator.next();
            String key = entry2.getKey();
            Map.Entry<String, MandatoryFieldInfo> entry3 = entry;
            MandatoryFieldInfo mandatoryFieldInfo = entry3.getValue();
            gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(gsonpath.generator.adapter.SharedFunctionsKt.addEscapedStatement(gsonpath.generator.adapter.SharedFunctionsKt.addWithNewLine(codeBlock, "case " + mandatoryFieldInfo.getIndexVariableName() + ":", new Object[0]).indent(), "fieldName = " + "\"" + mandatoryFieldInfo.getGsonField().getJsonPath() + "\"").addStatement("break", new Object[0]).unindent());
        }
        codeBlock.endControlFlow().addStatement("throw new gsonpath.JsonFieldMissingException(" + "\"" + "Mandatory JSON element '" + "\"" + " + fieldName + " + "\"" + "' was not found for class '" + concreteElement + "'" + "\"" + ")", new Object[0]).endControlFlow().endControlFlow();
    }

    private static final void addValidValueCheck(CodeBlock.Builder codeBlock, boolean addReturn) {
        gsonpath.generator.adapter.SharedFunctionsKt.addComment(codeBlock, "Ensure the object is not null.").beginControlFlow("if (!isValidValue(in))", new Object[0]).addStatement(addReturn ? "return null" : "break", new Object[0]).endControlFlow();
    }
}

