/*
 * Decompiled with CFR 0.152.
 */
package gsonpath.generator.adapter.standard;

import com.google.gson.stream.JsonWriter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import gsonpath.ProcessingException;
import gsonpath.generator.adapter.standard.SharedFunctionsKt;
import gsonpath.model.FieldInfo;
import gsonpath.model.GsonField;
import gsonpath.model.GsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a>\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0003\u00a8\u0006\u0013"}, d2={"createWriteMethod", "Lcom/squareup/javapoet/MethodSpec;", "elementClassName", "Lcom/squareup/javapoet/ClassName;", "rootElements", "Lgsonpath/model/GsonObject;", "serializeNulls", "", "writeGsonFieldWriter", "", "fieldDepth", "", "codeBlock", "Lcom/squareup/javapoet/CodeBlock$Builder;", "jsonMapping", "currentPath", "", "arrayNameCounterList", "", "gsonpath-compiler_main"})
public final class WriteFunctionsKt {
    @NotNull
    public static final MethodSpec createWriteMethod(@NotNull ClassName elementClassName, @NotNull GsonObject rootElements, boolean serializeNulls) throws ProcessingException {
        Intrinsics.checkParameterIsNotNull((Object)elementClassName, (String)"elementClassName");
        Intrinsics.checkParameterIsNotNull((Object)rootElements, (String)"rootElements");
        MethodSpec.Builder writeMethod = MethodSpec.methodBuilder((String)"write").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((Type)((Object)JsonWriter.class), "out", new Modifier[0]).addParameter((TypeName)elementClassName, "value", new Modifier[0]).addException((Type)((Object)IOException.class));
        CodeBlock.Builder codeBlock = gsonpath.generator.adapter.SharedFunctionsKt.addComment(gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(CodeBlock.builder().beginControlFlow("if (value == null)", new Object[0]).addStatement("out.nullValue()", new Object[0]).addStatement("return", new Object[0]).endControlFlow()), "Begin");
        WriteFunctionsKt.writeGsonFieldWriter(0, codeBlock, rootElements, "", serializeNulls, CollectionsKt.mutableListOf((Object[])new Boolean[0]));
        writeMethod.addCode(codeBlock.build());
        MethodSpec methodSpec = writeMethod.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"writeMethod.build()");
        return methodSpec;
    }

    private static final void writeGsonFieldWriter(int fieldDepth, CodeBlock.Builder codeBlock, GsonObject jsonMapping, String currentPath, boolean serializeNulls, List<Boolean> arrayNameCounterList) throws ProcessingException {
        codeBlock.addStatement("out.beginObject()", new Object[0]);
        for (String key : jsonMapping.keySet()) {
            Object value = jsonMapping.get(key);
            if (value instanceof GsonField) {
                FieldInfo fieldInfo2 = ((GsonField)value).getFieldInfo();
                SharedFunctionsKt.validateFieldAnnotations(fieldInfo2);
                TypeName fieldTypeName = fieldInfo2.getTypeName();
                boolean isPrimitive = fieldTypeName.isPrimitive();
                String objectName = "obj" + arrayNameCounterList.size();
                arrayNameCounterList.add(true);
                codeBlock.addStatement("$" + "T " + objectName + " = value." + fieldInfo2.getFieldName(), new Object[]{fieldTypeName});
                if (!isPrimitive && !serializeNulls) {
                    codeBlock.beginControlFlow("if (" + objectName + " != null)", new Object[0]);
                }
                codeBlock.addStatement("out.name(" + "\"" + key + "\"" + ")", new Object[0]);
                if (!isPrimitive && serializeNulls) {
                    codeBlock.beginControlFlow("if (" + objectName + " != null)", new Object[0]);
                }
                if (isPrimitive || gsonpath.generator.adapter.SharedFunctionsKt.getGSON_SUPPORTED_CLASSES().contains(fieldTypeName)) {
                    codeBlock.addStatement("out.value(" + objectName + ")", new Object[0]);
                } else {
                    String adapterName = fieldTypeName instanceof ParameterizedTypeName ? "new com.google.gson.reflect.TypeToken<" + fieldTypeName + ">(){}" : fieldTypeName.toString() + ".class";
                    codeBlock.addStatement("mGson.getAdapter(" + adapterName + ").write(out, " + objectName + ")", new Object[0]);
                }
                if (!isPrimitive) {
                    if (serializeNulls) {
                        codeBlock.nextControlFlow("else", new Object[0]).addStatement("out.nullValue()", new Object[0]);
                    }
                    codeBlock.endControlFlow();
                }
                gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock);
                continue;
            }
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type gsonpath.model.GsonObject");
            }
            GsonObject nextLevelMap = (GsonObject)object;
            if (nextLevelMap.size() <= 0) continue;
            CharSequence charSequence = currentPath;
            String newPath = charSequence.length() > 0 ? currentPath + "" + key : key;
            gsonpath.generator.adapter.SharedFunctionsKt.addComment(gsonpath.generator.adapter.SharedFunctionsKt.addNewLine(codeBlock), "Begin " + newPath).addStatement("out.name(" + "\"" + key + "\"" + ")", new Object[0]);
            WriteFunctionsKt.writeGsonFieldWriter(fieldDepth + 1, codeBlock, nextLevelMap, newPath, serializeNulls, arrayNameCounterList);
        }
        gsonpath.generator.adapter.SharedFunctionsKt.addComment(codeBlock, "End " + currentPath).addStatement("out.endObject()", new Object[0]);
    }
}

