/*
 * Decompiled with CFR 0.152.
 */
package gsonpath.model;

import com.google.common.base.Objects;
import gsonpath.model.GsonField;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0016\u0010\n\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0013\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0005H\u0086\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgsonpath/model/GsonObject;", "", "()V", "fieldMap", "Ljava/util/LinkedHashMap;", "", "addField", "Lgsonpath/model/GsonField;", "branchName", "field", "addObject", "gsonObject", "containsKey", "", "key", "equals", "other", "get", "hashCode", "", "keySet", "", "size", "toString", "gsonpath-compiler_main"})
public final class GsonObject {
    private final LinkedHashMap<String, Object> fieldMap = new LinkedHashMap();

    @NotNull
    public final GsonObject addObject(@NotNull String branchName, @NotNull GsonObject gsonObject) {
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        Intrinsics.checkParameterIsNotNull((Object)gsonObject, (String)"gsonObject");
        Map map2 = this.fieldMap;
        GsonObject gsonObject2 = gsonObject;
        map2.put(branchName, gsonObject2);
        return gsonObject;
    }

    @NotNull
    public final GsonField addField(@NotNull String branchName, @NotNull GsonField field) throws IllegalArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        if (this.containsKey(branchName)) {
            throw (Throwable)new IllegalArgumentException("Value already exists");
        }
        Map map2 = this.fieldMap;
        GsonField gsonField = field;
        map2.put(branchName, gsonField);
        return field;
    }

    public final int size() {
        return this.fieldMap.size();
    }

    @NotNull
    public final Set<String> keySet() {
        Set<String> set = this.fieldMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"fieldMap.keys");
        return set;
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.fieldMap.get(key);
    }

    public final boolean containsKey(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.fieldMap.containsKey(key);
    }

    public boolean equals(@Nullable Object other) {
        GsonObject gsonObject;
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        GsonObject gsonObject2 = gsonObject = (GsonObject)other;
        if (gsonObject2 == null) {
            Intrinsics.throwNpe();
        }
        return Objects.equal(this.fieldMap, gsonObject2.fieldMap);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldMap});
    }

    @NotNull
    public String toString() {
        return "GsonObject: " + this.fieldMap;
    }
}

