/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.api.validator.jsr303ext.engine;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import net.leadware.persistence.tools.api.exceptions.InvalidEntityInstanceStateException;

public class JSR303ValidatorEngine {
    private ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
    private Validator validator = this.validatorFactory.getValidator();
    private static JSR303ValidatorEngine _instance = null;

    private JSR303ValidatorEngine() {
    }

    public static synchronized JSR303ValidatorEngine getDefaultInstance() {
        if (_instance == null) {
            _instance = new JSR303ValidatorEngine();
        }
        return _instance;
    }

    public static synchronized JSR303ValidatorEngine getInstance(ValidatorFactory validatorFactory) {
        if (_instance == null) {
            _instance = new JSR303ValidatorEngine();
        }
        _instance.setValidatorFactory(validatorFactory);
        return _instance;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        if (validatorFactory != null) {
            this.validatorFactory = validatorFactory;
            this.validator = validatorFactory.getValidator();
        }
    }

    public <T> void validate(T entity) {
        Set constraintViolations = this.validator.validate(entity, new Class[0]);
        if (constraintViolations == null || constraintViolations.size() == 0) {
            return;
        }
        ConstraintViolation first = (ConstraintViolation)constraintViolations.iterator().next();
        String message = first.getMessage();
        String entityName = first.getRootBeanClass().getSimpleName();
        String propertyName = first.getPropertyPath().toString();
        throw new InvalidEntityInstanceStateException(entityName, propertyName, message);
    }
}

