/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.generator.base;

import java.lang.annotation.Annotation;
import javax.persistence.EntityManager;
import net.leadware.persistence.tools.api.dao.constants.DAOMode;
import net.leadware.persistence.tools.api.dao.constants.DAOValidatorEvaluationTime;
import net.leadware.persistence.tools.api.generator.base.IDAOGeneratorManager;
import net.leadware.persistence.tools.core.dao.utils.DAOValidatorHelper;

public abstract class AbstractDAOGeneratorManager
implements IDAOGeneratorManager<Annotation> {
    protected EntityManager generatorEntityManager;
    protected EntityManager entityManager;
    protected Annotation annotation;
    protected DAOValidatorEvaluationTime systemEvaluationTime;
    protected DAOMode systemDAOMode;

    public void initialize(Annotation annotation, EntityManager generatorEntityManager, EntityManager entityManager, DAOMode systemMode, DAOValidatorEvaluationTime systemEvaluationTime) {
        this.annotation = annotation;
        this.generatorEntityManager = generatorEntityManager;
        this.entityManager = entityManager;
        this.systemDAOMode = systemMode;
        this.systemEvaluationTime = systemEvaluationTime;
    }

    protected boolean isProcessable() {
        boolean correctMode = DAOValidatorHelper.arraryContains(this.getAnnotationMode(), this.systemDAOMode);
        boolean correctTime = DAOValidatorHelper.arraryContains(this.getAnnotationEvaluationTime(), this.systemEvaluationTime);
        return correctMode && correctTime;
    }

    protected abstract DAOMode[] getAnnotationMode();

    protected abstract DAOValidatorEvaluationTime[] getAnnotationEvaluationTime();
}

