/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.api;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.leanix.dropkit.api.ApiException;
import net.leanix.dropkit.api.JsonUtil;
import net.leanix.dropkit.api.Response;
import net.leanix.dropkit.api.ValidationException;

public class ApiClient {
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String basePath;
    private String username;
    private String password;

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setApiKey(String apiKey) {
        this.addDefaultHeader("Api-Key", apiKey);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
    }

    public String escapeString(String str) {
        return str;
    }

    private Client getClient(String host) {
        if (!this.hostMap.containsKey(host)) {
            Client client = Client.create();
            client.addFilter((ClientFilter)new LoggingFilter());
            if (this.username != null) {
                client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
            }
            this.hostMap.put(host, client);
        }
        return this.hostMap.get(host);
    }

    public static Object deserialize(String json, String containerType, Class cls) throws ApiException {
        try {
            if ("List".equals(containerType) || "Array".equals(containerType)) {
                CollectionType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, cls);
                List response = (List)JsonUtil.getJsonMapper().readValue(json, (JavaType)typeInfo);
                return response;
            }
            if (String.class.equals((Object)cls)) {
                if (json != null && json.startsWith("\"") && json.endsWith("\"") && json.length() > 1) {
                    return json.substring(1, json.length() - 2);
                }
                return json;
            }
            return JsonUtil.getJsonMapper().readValue(json, cls);
        }
        catch (IOException e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public static String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                return JsonUtil.getJsonMapper().writeValueAsString(obj);
            }
            return null;
        }
        catch (Exception e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public String invokeAPI(String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams) throws ApiException {
        String host = this.basePath;
        Client client = this.getClient(host);
        StringBuilder b = new StringBuilder();
        for (String key : queryParams.keySet()) {
            String value = queryParams.get(key);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(key)).append("=").append(this.escapeString(value));
        }
        String querystring = b.toString();
        WebResource.Builder builder = client.resource(host + path + querystring).accept(new String[]{"application/json"});
        for (String key : headerParams.keySet()) {
            builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            response = body == null ? (ClientResponse)builder.post(ClientResponse.class, (Object)ApiClient.serialize(body)) : (ClientResponse)((WebResource.Builder)builder.type("application/json")).post(ClientResponse.class, (Object)ApiClient.serialize(body));
        } else if ("PUT".equals(method)) {
            response = body == null ? (ClientResponse)builder.put(ClientResponse.class, (Object)ApiClient.serialize(body)) : (ClientResponse)((WebResource.Builder)builder.type("application/json")).put(ClientResponse.class, (Object)ApiClient.serialize(body));
        } else if ("DELETE".equals(method)) {
            response = body == null ? (ClientResponse)builder.delete(ClientResponse.class, (Object)ApiClient.serialize(body)) : (ClientResponse)((WebResource.Builder)builder.type("application/json")).delete(ClientResponse.class, (Object)ApiClient.serialize(body));
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        if (response.getStatus() == 200) {
            return (String)response.getEntity(String.class);
        }
        if (response.getStatus() == 422) {
            Response resp = null;
            resp = (Response)ApiClient.deserialize((String)response.getEntity(String.class), "", Response.class);
            throw new ValidationException(resp);
        }
        throw new ApiException(response.getStatus(), "Unknown error");
    }
}

