/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.application.ApplicationBootstrapException;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.application.Artifact;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.libraries.LibrariesManager;
import net.lecousin.framework.application.libraries.classpath.DefaultLibrariesManager;
import net.lecousin.framework.concurrent.Console;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskMonitoring;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.tasks.LoadPropertiesFileTask;
import net.lecousin.framework.concurrent.tasks.SavePropertiesFileTask;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.locale.LocalizedProperties;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.ObjectUtil;
import net.lecousin.framework.util.Pair;

public final class Application {
    public static final String PROPERTY_LOGGING_CONFIGURATION_URL = "net.lecousin.logging.configuration.url";
    public static final String PROPERTY_INSTALLATION_DIRECTORY = "net.lecousin.application.install.directory";
    public static final String PROPERTY_CONFIG_DIRECTORY = "net.lecousin.application.config.directory";
    public static final String PROPERTY_LOG_DIRECTORY = "net.lecousin.application.log.directory";
    public static final String PROPERTY_TMP_DIRECTORY = "net.lecousin.application.tmpdir";
    public static final String PROPERTY_LANGUAGE_TAG = "net.lecousin.framework.locale.language";
    private long startTime;
    private Artifact artifact;
    private String[] commandLineArguments;
    private Hashtable<String, String> properties;
    private boolean debugMode;
    private ThreadFactory threadFactory;
    private LibrariesManager librariesManager;
    private ApplicationClassLoader appClassLoader;
    private Console console;
    private Properties preferences = null;
    private Locale locale;
    private LocalizedProperties localizedProperties;
    private String[] languageTag;
    private LoggerFactory loggerFactory;
    private Map<Class<?>, Object> instances = new HashMap();
    private Map<String, Object> data = new HashMap<String, Object>();
    private ArrayList<Closeable> toCloseSync = new ArrayList();
    private ArrayList<AsyncCloseable<?>> toCloseAsync = new ArrayList();
    private ArrayList<Thread> toInterrupt = new ArrayList();
    private boolean stopping = false;
    private IAsync<Exception> loadingPreferences = null;
    IAsync<IOException> savingPreferences = null;

    private Application(Artifact artifact, String[] commandLineArguments, Map<String, String> properties, boolean debugMode, ThreadFactory threadFactory, LibrariesManager librariesManager) {
        this.startTime = System.nanoTime();
        this.artifact = artifact;
        this.commandLineArguments = commandLineArguments;
        this.properties = properties != null ? new Hashtable<String, String>(properties) : new Hashtable();
        this.properties.put("groupId", artifact.getGroupId());
        this.properties.put("artifactId", artifact.getArtifactId());
        this.properties.put("version", artifact.getVersion().toString());
        this.debugMode = debugMode;
        this.threadFactory = threadFactory;
        this.librariesManager = librariesManager;
        this.console = new Console(this);
        if (debugMode) {
            TaskMonitoring.checkLocksOfBlockingTasks = true;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public Version getVersion() {
        return this.artifact.getVersion();
    }

    public String getFullName() {
        return this.artifact.toString();
    }

    public List<String> getCommandLineArguments() {
        return Arrays.asList(this.commandLineArguments);
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isReleaseMode() {
        return !this.debugMode;
    }

    public String getProperty(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return System.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Map<String, String> getApplicationSpecificProperties() {
        return this.properties;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public Console getConsole() {
        return this.console;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale l) {
        this.locale = l;
        String lt = l.toLanguageTag();
        this.languageTag = lt.split("-");
        this.setPreference(PROPERTY_LANGUAGE_TAG, lt);
    }

    public LocalizedProperties getLocalizedProperties() {
        return this.localizedProperties;
    }

    public String[] getLanguageTag() {
        return this.languageTag;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public Logger getDefaultLogger() {
        return this.loggerFactory.getRoot();
    }

    public LibrariesManager getLibrariesManager() {
        return this.librariesManager;
    }

    public ApplicationClassLoader getClassLoader() {
        return this.appClassLoader;
    }

    public IO.Readable getResource(String filename, byte priority) {
        IOProvider.Readable provider = this.appClassLoader.getIOProvider(filename);
        if (provider == null) {
            return null;
        }
        try {
            return provider.provideIOReadable(priority);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toClose(Closeable c) {
        ArrayList<Closeable> arrayList = this.toCloseSync;
        synchronized (arrayList) {
            this.toCloseSync.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toClose(AsyncCloseable<?> c) {
        ArrayList<AsyncCloseable<?>> arrayList = this.toCloseAsync;
        synchronized (arrayList) {
            this.toCloseAsync.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(Closeable c) {
        ArrayList<Closeable> arrayList = this.toCloseSync;
        synchronized (arrayList) {
            this.toCloseSync.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(AsyncCloseable<?> c) {
        ArrayList<AsyncCloseable<?>> arrayList = this.toCloseAsync;
        synchronized (arrayList) {
            this.toCloseAsync.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toInterruptOnShutdown(Thread t) {
        ArrayList<Thread> arrayList = this.toInterrupt;
        synchronized (arrayList) {
            this.toInterrupt.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupted(Thread t) {
        ArrayList<Thread> arrayList = this.toInterrupt;
        synchronized (arrayList) {
            this.toInterrupt.remove(t);
        }
    }

    public boolean isStopping() {
        return this.stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInstance(Class<T> clazz) {
        Map<Class<?>, Object> map = this.instances;
        synchronized (map) {
            return (T)this.instances.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T setInstance(Class<T> clazz, T instance) {
        Map<Class<?>, Object> map = this.instances;
        synchronized (map) {
            return (T)this.instances.put(clazz, instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeInstance(Class<T> clazz) {
        Map<Class<?>, Object> map = this.instances;
        synchronized (map) {
            return (T)this.instances.remove(clazz);
        }
    }

    public Object getData(String name) {
        return this.data.get(name);
    }

    public Object setData(String name, Object value) {
        return this.data.put(name, value);
    }

    public Object removeData(String name) {
        return this.data.remove(name);
    }

    public static IAsync<ApplicationBootstrapException> start(Artifact artifact, String[] commandLineArguments, Map<String, String> properties, boolean debugMode, ThreadFactory threadFactory, LibrariesManager librariesManager, Appender defaultLogAppender) {
        final Application app = new Application(artifact, commandLineArguments, properties, debugMode, threadFactory, librariesManager);
        String dir = app.getProperty(PROPERTY_CONFIG_DIRECTORY);
        if (dir == null) {
            app.setProperty(PROPERTY_CONFIG_DIRECTORY, app.getProperty("user.home") + "/.lc.apps/" + app.getGroupId() + "/" + app.getArtifactId() + "/cfg");
        }
        if ((dir = app.getProperty(PROPERTY_LOG_DIRECTORY)) == null) {
            app.setProperty(PROPERTY_LOG_DIRECTORY, app.getProperty("user.home") + "/.lc.apps/" + app.getGroupId() + "/" + app.getArtifactId() + "/log");
        }
        if (app.isDebugMode()) {
            Console c = app.getConsole();
            c.out("---- Application " + artifact.toString() + " ----");
            c.out("Application arguments:");
            for (String arg : app.commandLineArguments) {
                c.out(" - " + arg);
            }
            c.out("Environment variables:");
            for (Map.Entry entry : System.getenv().entrySet()) {
                c.out(" - " + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
            c.out("JVM Properties:");
            for (Map.Entry entry : System.getProperties().entrySet()) {
                c.out(" - " + entry.getKey() + "=" + entry.getValue());
            }
            c.out("Application Properties:");
            for (Map.Entry entry : app.getApplicationSpecificProperties().entrySet()) {
                c.out(" - " + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
            c.out("-----------------------------------------");
        }
        LCCore.initEnvironment();
        app.loggerFactory = new LoggerFactory(app, defaultLogAppender);
        LCCore.start(app);
        JoinPoint<Exception> loading = new JoinPoint<Exception>();
        IAsync<Exception> loadPref = app.loadPreferences();
        loading.addToJoin(loadPref);
        Task.Cpu<Void, NoException> cpu = new Task.Cpu<Void, NoException>("Initialize localization", 3){

            @Override
            public Void run() {
                String lang = app.getPreference(Application.PROPERTY_LANGUAGE_TAG);
                if (lang == null) {
                    lang = app.getProperty(Application.PROPERTY_LANGUAGE_TAG);
                }
                if (lang != null) {
                    app.locale = Locale.forLanguageTag(lang);
                } else {
                    app.locale = Locale.getDefault();
                }
                Application.access$102(app, app.locale.toLanguageTag().split("-"));
                app.localizedProperties = new LocalizedProperties(app);
                return null;
            }
        };
        cpu.startOn(loadPref, true);
        loading.addToJoin(cpu.getOutput());
        loading.start();
        Async<ApplicationBootstrapException> sp = new Async<ApplicationBootstrapException>();
        loading.onDone(() -> {
            app.appClassLoader = librariesManager.start(app);
            librariesManager.onLibrariesLoaded().onDone(sp, error -> new ApplicationBootstrapException("Error loading libraries", (Throwable)error));
        });
        return sp;
    }

    public static IAsync<ApplicationBootstrapException> start(Artifact artifact, boolean debugMode) {
        return Application.start(artifact, new String[0], debugMode);
    }

    public static IAsync<ApplicationBootstrapException> start(Artifact artifact, String[] args, boolean debugMode) {
        return Application.start(artifact, args, null, debugMode, Executors.defaultThreadFactory(), new DefaultLibrariesManager(), null);
    }

    public void stop() {
        System.out.println("Stopping application");
        this.stopping = true;
        System.out.println(" * Closing resources");
        for (Closeable closeable : new ArrayList<Closeable>(this.toCloseSync)) {
            System.out.println("     - " + closeable);
            try {
                closeable.close();
            }
            catch (Exception exception) {
                System.err.println("Error closing resource " + closeable);
                exception.printStackTrace(System.err);
            }
        }
        System.out.println(" * Stopping threads");
        for (Thread thread : new ArrayList<Thread>(this.toInterrupt)) {
            if (!thread.isAlive()) continue;
            System.out.println("     - " + thread);
            thread.interrupt();
        }
        LinkedList closing = new LinkedList();
        for (AsyncCloseable<?> asyncCloseable : new ArrayList(this.toCloseAsync)) {
            System.out.println(" * Closing " + asyncCloseable);
            closing.add(new Pair(asyncCloseable, asyncCloseable.closeAsync()));
        }
        this.toCloseAsync.clear();
        long l = System.currentTimeMillis();
        boolean allClosed = false;
        do {
            Iterator it = closing.iterator();
            while (it.hasNext()) {
                Pair s = (Pair)it.next();
                if (!((IAsync)s.getValue2()).isDone()) continue;
                System.out.println(" * Closed: " + s.getValue1());
                it.remove();
            }
            if (closing.isEmpty()) {
                allClosed = true;
                continue;
            }
            try {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - l <= 15000L) continue;
                System.out.println("Ressources are still closing, but we don't wait more than 15 seconds.");
                allClosed = true;
            }
            catch (InterruptedException e) {
                allClosed = true;
            }
        } while (!allClosed);
        this.console.close();
        System.out.println("Application stopped.");
    }

    public String getPreference(String name) {
        if (this.preferences == null) {
            this.loadPreferences().block(0L);
        }
        return this.preferences.getProperty(name);
    }

    public void setPreference(String name, String value) {
        if (this.preferences.containsKey(name) && ObjectUtil.equalsOrNull(value, this.preferences.get(name))) {
            return;
        }
        this.preferences.put(name, value);
        this.savePreferences();
    }

    public synchronized IAsync<Exception> loadPreferences() {
        if (this.loadingPreferences != null) {
            return this.loadingPreferences;
        }
        File f = new File(this.getProperty(PROPERTY_CONFIG_DIRECTORY));
        if (!(f = new File(f, "preferences")).exists()) {
            this.getDefaultLogger().info("No preferences file");
            this.preferences = new Properties();
            this.loadingPreferences = new Async<boolean>(true);
            return this.loadingPreferences;
        }
        this.getDefaultLogger().info("Loading preferences from " + f.getAbsolutePath());
        this.loadingPreferences = LoadPropertiesFileTask.loadPropertiesFile(f, StandardCharsets.UTF_8, (byte)2, false, props -> {
            this.preferences = props;
        });
        return this.loadingPreferences;
    }

    private synchronized void savePreferences() {
        if (this.savingPreferences != null && !this.savingPreferences.isDone()) {
            this.savingPreferences.onDone(this::savePreferences);
            return;
        }
        File f = new File(this.getProperty(PROPERTY_CONFIG_DIRECTORY));
        if (!(f.exists() && f.isDirectory() || f.mkdirs())) {
            this.loggerFactory.getRoot().warn("Unable to create directory to save preferences: " + f.getAbsolutePath());
        }
        f = new File(f, "preferences");
        this.getDefaultLogger().info("Saving preferences to " + f.getAbsolutePath());
        this.savingPreferences = SavePropertiesFileTask.savePropertiesFile(this.preferences, f, StandardCharsets.UTF_8, (byte)5);
    }

    static /* synthetic */ String[] access$102(Application x0, String[] x1) {
        x0.languageTag = x1;
        return x1;
    }
}

