/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import java.io.Closeable;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.StandaloneLCCore;
import net.lecousin.framework.application.libraries.LibrariesManager;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.mutable.MutableBoolean;
import net.lecousin.framework.util.AsyncCloseable;

public final class LCCore {
    private static Environment instance = null;
    private static boolean started = false;
    private static Thread mainThread = null;
    private static Exception stop = null;
    private static TurnArray<Runnable> toDoInMainThread = new TurnArray(5);
    private static MainThreadExecutor mainThreadExecutor = new MainThreadExecutor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable toExecute) {
            TurnArray turnArray = toDoInMainThread;
            synchronized (turnArray) {
                toDoInMainThread.push(toExecute);
                toDoInMainThread.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable pop() {
            TurnArray turnArray = toDoInMainThread;
            synchronized (turnArray) {
                return (Runnable)toDoInMainThread.pollFirst();
            }
        }
    };

    private LCCore() {
    }

    public static Environment get() {
        return instance;
    }

    public static void set(Environment env) {
        if (instance != null) {
            throw new IllegalStateException("LCCore environment already exists");
        }
        instance = env;
    }

    public static void initEnvironment() {
        String protocols;
        if (System.getProperty("org.apache.commons.logging.Log") == null) {
            System.setProperty("org.apache.commons.logging.Log", "net.lecousin.framework.log.bridges.ApacheCommonsLogging");
        }
        if ((protocols = System.getProperty("java.protocol.handler.pkgs")) == null) {
            protocols = "";
        }
        if (!protocols.contains("net.lecousin.framework.protocols")) {
            if (protocols.length() > 0) {
                protocols = protocols + "|";
            }
            protocols = protocols + "net.lecousin.framework.protocols";
            System.setProperty("java.protocol.handler.pkgs", protocols);
        }
    }

    public static boolean isStarted() {
        return started;
    }

    public static synchronized void start() {
        if (started) {
            throw new IllegalStateException("LCCore environment already started");
        }
        started = true;
        LCCore.initEnvironment();
        instance.start();
        new Task.Cpu<Void, Exception>("Initializing framework tools", 4){

            @Override
            public Void run() {
                MemoryManager.init();
                return null;
            }
        }.start();
    }

    static synchronized void start(Application app) {
        if (instance == null) {
            StandaloneLCCore env = new StandaloneLCCore();
            LCCore.set(env);
        }
        instance.add(app);
        if (!LCCore.isStarted()) {
            LCCore.start();
        }
    }

    public static Application getApplication() {
        return instance.getApplication();
    }

    public static boolean isStopping() {
        return stop != null;
    }

    public static MutableBoolean stop(final boolean forceJvmToStop) {
        if (stop != null) {
            new Exception("LCCore already stopped", stop).printStackTrace(System.err);
            return new MutableBoolean(true);
        }
        stop = new Exception("LCCore stop requested here");
        final MutableBoolean stopped = new MutableBoolean(false);
        new Thread("Stopping LCCore"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = toDoInMainThread;
                synchronized (object) {
                    toDoInMainThread.notify();
                }
                if (instance != null) {
                    instance.stop();
                }
                if (forceJvmToStop) {
                    System.out.println("Stop JVM.");
                    System.exit(0);
                }
                object = stopped;
                synchronized (object) {
                    stopped.set(true);
                    stopped.notifyAll();
                }
            }
        }.start();
        return stopped;
    }

    public static void keepMainThread(Runnable toContinue) {
        mainThread = Thread.currentThread();
        Thread thread = new Thread(toContinue, "LC Core - Main");
        thread.start();
        LCCore.mainThreadLoop();
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mainThreadLoop() {
        while (stop == null) {
            Runnable todo = null;
            TurnArray<Runnable> turnArray = toDoInMainThread;
            synchronized (turnArray) {
                if (toDoInMainThread.isEmpty()) {
                    try {
                        toDoInMainThread.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                todo = toDoInMainThread.pop();
            }
            todo.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeInMainThread(Runnable toExecute) {
        Class<LCCore> clazz = LCCore.class;
        synchronized (LCCore.class) {
            mainThreadExecutor.execute(toExecute);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceMainThreadExecutor(MainThreadExecutor executor) {
        Class<LCCore> clazz = LCCore.class;
        synchronized (LCCore.class) {
            Runnable toExecute;
            MainThreadExecutor previous = mainThreadExecutor;
            mainThreadExecutor = executor;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            while ((toExecute = previous.pop()) != null) {
                executor.execute(toExecute);
            }
            return;
        }
    }

    public static interface MainThreadExecutor {
        public void execute(Runnable var1);

        public Runnable pop();
    }

    public static interface Environment {
        public void start();

        public void add(Application var1);

        public Application getApplication();

        public void toClose(Closeable var1);

        public void toClose(AsyncCloseable<?> var1);

        public void closed(Closeable var1);

        public void closed(AsyncCloseable<?> var1);

        public LibrariesManager getSystemLibraries();

        public Logger getSystemLogger(String var1);

        default public Logger getThreadingLogger() {
            return this.getSystemLogger("Threading");
        }

        default public Logger getMemoryLogger() {
            return this.getSystemLogger("Memory");
        }

        public void stop();

        public boolean isStopping();
    }
}

