/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.ImageIcon;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationBootstrap;
import net.lecousin.framework.application.ApplicationBootstrapException;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.application.ApplicationConfiguration;
import net.lecousin.framework.application.Artifact;
import net.lecousin.framework.application.SplashScreen;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.VersionSpecification;
import net.lecousin.framework.application.libraries.LibraryManagementException;
import net.lecousin.framework.application.libraries.artifacts.ArtifactsLibrariesManager;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptor;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptorLoader;
import net.lecousin.framework.application.libraries.artifacts.LoadedLibrary;
import net.lecousin.framework.application.libraries.classloader.AbstractClassLoader;
import net.lecousin.framework.application.libraries.classloader.AppClassLoader;
import net.lecousin.framework.application.libraries.classpath.LoadLibraryExtensionPointsFile;
import net.lecousin.framework.application.libraries.classpath.LoadLibraryPluginsFile;
import net.lecousin.framework.collections.CollectionsUtil;
import net.lecousin.framework.collections.Tree;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.tasks.drives.FullReadFileTask;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromPathUsingClassloader;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.mutable.MutableInteger;
import net.lecousin.framework.plugins.CustomExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoints;
import net.lecousin.framework.progress.FakeWorkProgress;
import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.ThreadUtil;
import net.lecousin.framework.util.Triple;

public class DynamicLibrariesManager
implements ArtifactsLibrariesManager {
    private Application app;
    private File appDir;
    private AppClassLoader appClassLoader;
    private List<File> devPaths;
    private SplashScreen splash;
    private List<LibraryDescriptorLoader> loaders;
    private JoinPoint<LibraryManagementException> canStartApp = new JoinPoint();
    private Lib appLib;
    private ApplicationConfiguration appCfg;
    private List<Triple<String, String, String>> loadPlugins;
    private Map<String, Lib> libraries = new HashMap<String, Lib>();

    public DynamicLibrariesManager(List<File> devPaths, SplashScreen splash, List<LibraryDescriptorLoader> loaders, File appDir, ApplicationConfiguration cfg, List<Triple<String, String, String>> plugins) {
        this.devPaths = devPaths;
        this.splash = splash;
        this.loaders = loaders;
        this.appCfg = cfg;
        this.loadPlugins = plugins;
        this.appDir = appDir;
    }

    @Override
    public ApplicationClassLoader start(Application app) {
        this.app = app;
        this.appClassLoader = new AppClassLoader(app);
        app.getDefaultLogger().debug("Start loading application in development mode");
        long work = this.splash != null ? this.splash.getRemainingWork() : 0L;
        work -= work * 40L / 100L;
        long stepDevProjects = this.devPaths != null ? work / 20L : 0L;
        long stepDependencies = work * (long)(this.devPaths != null ? 70 : 75) / 100L;
        long stepVersionConflicts = work / 20L;
        long stepLoad = work - stepDevProjects - stepDependencies - stepVersionConflicts;
        if (this.splash != null) {
            if (this.appCfg.getSplash() != null) {
                File splashFile = new File(this.appDir, this.appCfg.getSplash());
                if (splashFile.exists()) {
                    this.loadSplashFile(splashFile);
                } else {
                    this.splash.loadDefaultLogo();
                }
            } else {
                this.splash.loadDefaultLogo();
            }
        }
        if (this.devPaths != null) {
            this.developmentMode(stepDevProjects, stepDependencies, stepVersionConflicts, stepLoad);
        } else {
            this.productionMode(stepDependencies, stepVersionConflicts, stepLoad);
        }
        return this.appClassLoader;
    }

    private void loadSplashFile(File splashFile) {
        final FullReadFileTask read = new FullReadFileTask(splashFile, 1);
        read.start();
        Task.Cpu<Void, NoException> load = new Task.Cpu<Void, NoException>("Loading splash image", 1){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                ImageIcon img = new ImageIcon((byte[])read.getResult());
                if (DynamicLibrariesManager.this.splash == null) {
                    return null;
                }
                SplashScreen splashScreen = DynamicLibrariesManager.this.splash;
                synchronized (splashScreen) {
                    while (!DynamicLibrariesManager.this.splash.isReady()) {
                        if (ThreadUtil.wait(DynamicLibrariesManager.this.splash, 0L)) continue;
                        return null;
                    }
                }
                DynamicLibrariesManager.this.splash.setLogo(img, true);
                return null;
            }
        };
        read.ondone(load, false);
    }

    private void developmentMode(long stepDevProjects, long stepDependencies, long stepVersionConflicts, long stepLoad) {
        if (this.splash != null) {
            this.splash.setText("Analyzing development projects");
        }
        AsyncSupplier<List<LibraryDescriptor>, LibraryManagementException> devProjects = this.loadDevProjects(stepDevProjects);
        devProjects.thenStart("Load application libraries", (byte)2, () -> this.loadDevApp(devProjects, stepDependencies, stepVersionConflicts, stepLoad), this.canStartApp);
    }

    private AsyncSupplier<List<LibraryDescriptor>, LibraryManagementException> loadDevProjects(long stepDevProjects) {
        JoinPoint jpDevProjects = new JoinPoint();
        ArrayList devProjects = new ArrayList(this.devPaths.size());
        new Task.Cpu.FromRunnable("Load development projects", 2, () -> {
            int nb = this.devPaths.size();
            long w = stepDevProjects;
            for (File dir : this.devPaths) {
                long step = w / (long)nb--;
                w -= step;
                AsyncSupplier load = CollectionsUtil.filterSingle(loader -> loader.detect(dir)).andThen(loader -> loader != null ? loader.loadProject(dir, (byte)2) : null).apply(this.loaders);
                if (load == null) {
                    this.app.getDefaultLogger().error("Unknown type of project: " + dir.getAbsolutePath());
                    if (this.splash == null) continue;
                    this.splash.progress(step);
                    continue;
                }
                if (this.splash != null) {
                    load.onDone(() -> this.splash.progress(step));
                }
                devProjects.add(load);
                jpDevProjects.addToJoin(load);
            }
            jpDevProjects.start();
            this.devPaths = null;
        }).start();
        AsyncSupplier<List<LibraryDescriptor>, LibraryManagementException> result = new AsyncSupplier<List<LibraryDescriptor>, LibraryManagementException>();
        jpDevProjects.onDone(() -> result.unblockSuccess(CollectionsUtil.map(devProjects, AsyncSupplier::getResult)), result);
        return result;
    }

    private void loadDevApp(AsyncSupplier<List<LibraryDescriptor>, LibraryManagementException> devProjects, long stepDependencies, long stepVersionConflicts, long stepLoad) {
        LibraryDescriptor appLibDescr = null;
        for (LibraryDescriptor lib : devProjects.getResult()) {
            if (lib == null || !this.app.getGroupId().equals(lib.getGroupId()) || !this.app.getArtifactId().equals(lib.getArtifactId())) continue;
            appLibDescr = lib;
            break;
        }
        if (appLibDescr == null) {
            this.canStartApp.error(new LibraryManagementException("Cannot find application " + this.app.getGroupId() + ':' + this.app.getArtifactId()));
            return;
        }
        if (!appLibDescr.hasClasses()) {
            this.canStartApp.error(new LibraryManagementException("Application project must provide classes"));
            return;
        }
        this.app.getDefaultLogger().debug("Development projects analyzed, loading application");
        LinkedList<LibraryDescriptor> addPlugins = new LinkedList<LibraryDescriptor>();
        for (Triple<String, String, String> t : this.loadPlugins) {
            this.app.getDefaultLogger().debug("Searching projects matching " + t.getValue1() + ':' + t.getValue2() + ':' + t.getValue3());
            for (LibraryDescriptor lib : devProjects.getResult()) {
                if (!lib.getGroupId().equals(t.getValue1()) || t.getValue2() != null && !lib.getArtifactId().equals(t.getValue2()) || t.getValue3() != null && !lib.getVersionString().equals(t.getValue3())) continue;
                addPlugins.add(lib);
                this.app.getDefaultLogger().debug("Plug-in to load: " + lib.toString());
            }
        }
        this.loadApplicationLibrary(appLibDescr, addPlugins, stepDependencies, stepVersionConflicts, stepLoad);
    }

    private void productionMode(long stepDependencies, long stepVersionConflicts, long stepLoad) {
        this.searchApplication(0, stepDependencies, stepVersionConflicts, stepLoad);
    }

    private void searchApplication(int loaderIndex, long stepDependencies, long stepVersionConflicts, long stepLoad) {
        if (loaderIndex == this.loaders.size()) {
            this.canStartApp.error(new LibraryManagementException("Application not found"));
            return;
        }
        AsyncSupplier<? extends LibraryDescriptor, LibraryManagementException> load = this.loaders.get(loaderIndex).loadLibrary(this.app.getGroupId(), this.app.getArtifactId(), new VersionSpecification.SingleVersion(this.app.getVersion()), (byte)2, new ArrayList<LibrariesRepository>(0));
        load.onDone(() -> {
            if (!load.isSuccessful() || load.getResult() == null) {
                this.searchApplication(loaderIndex + 1, stepDependencies, stepVersionConflicts, stepLoad);
                return;
            }
            LibraryDescriptor appLibDescr = (LibraryDescriptor)load.getResult();
            if (!appLibDescr.hasClasses()) {
                this.canStartApp.error(new LibraryManagementException("Application project must provide classes"));
                return;
            }
            this.app.getDefaultLogger().debug("Loading application");
            LinkedList<LibraryDescriptor> addPlugins = new LinkedList<LibraryDescriptor>();
            this.loadApplicationLibrary(appLibDescr, addPlugins, stepDependencies, stepVersionConflicts, stepLoad);
        });
    }

    private void loadApplicationLibrary(LibraryDescriptor descr, List<LibraryDescriptor> addPlugins, long stepDependencies, long stepVersionConflicts, long stepLoad) {
        this.app.getDefaultLogger().debug("Building dependencies tree");
        if (this.splash != null) {
            this.splash.setText("Analyzing dependencies");
        }
        Tree.WithParent<LibraryDescriptorLoader.DependencyNode> tree = new Tree.WithParent<LibraryDescriptorLoader.DependencyNode>(null);
        HashMap<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts = new HashMap<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>>();
        JoinPoint<NoException> treeDone = new JoinPoint<NoException>();
        this.buildDependenciesTree(descr, tree, artifacts, new ArrayList<Pair<String, String>>(0), treeDone, addPlugins, this.splash, stepDependencies);
        treeDone.start();
        ResolveVersionConflicts resolveConflicts = new ResolveVersionConflicts(artifacts, descr.getLoader(), this.splash, stepVersionConflicts);
        resolveConflicts.startOn(treeDone, true);
        resolveConflicts.getOutput().onDone(() -> {
            this.app.getDefaultLogger().debug("Dependencies analyzed, loading and initializing libraries");
            if (this.splash != null) {
                this.splash.setText("Initializing libraries");
            }
            Lib lib = new Lib();
            lib.descr = descr;
            this.libraries.put(descr.getGroupId() + ':' + descr.getArtifactId(), lib);
            this.appLib = lib;
            new LoadLibrary(lib, (Map)resolveConflicts.getResult(), addPlugins, this.splash, stepLoad).start();
            lib.load.thenStart(new Task.Cpu<Void, NoException>("Finishing to initialize", 2){

                @Override
                public Void run() {
                    if (DynamicLibrariesManager.this.canStartApp.hasError()) {
                        return null;
                    }
                    DynamicLibrariesManager.this.app.getDefaultLogger().debug("Libraries initialized.");
                    ExtensionPoints.allPluginsLoaded();
                    DynamicLibrariesManager.this.canStartApp.unblock();
                    return null;
                }
            }, this.canStartApp);
        }, this.canStartApp);
    }

    private void buildDependenciesTree(LibraryDescriptor descr, Tree.WithParent<LibraryDescriptorLoader.DependencyNode> tree, Map<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts, Collection<Pair<String, String>> exclusions, JoinPoint<NoException> jp, List<LibraryDescriptor> addPlugins, WorkProgress progress, long work) {
        List<LibraryDescriptor.Dependency> deps = DynamicLibrariesManager.getDependenciesWithPlugins(descr, addPlugins);
        int nb = deps.size();
        for (LibraryDescriptor.Dependency dep : deps) {
            if (DynamicLibrariesManager.isMatching(dep.getGroupId(), dep.getArtifactId(), exclusions)) {
                --nb;
                continue;
            }
            long step = work / (long)nb--;
            work -= step;
            this.app.getDefaultLogger().debug("Dependency: " + descr.getGroupId() + ':' + descr.getArtifactId() + ':' + descr.getVersionString() + " => " + dep.getGroupId() + ':' + dep.getArtifactId() + ':' + dep.getVersionSpecification());
            this.buildDependenciesTreeForDependency(descr, tree, artifacts, exclusions, jp, dep, progress, step);
        }
        if (progress != null && work > 0L) {
            progress.progress(work);
        }
    }

    private static List<LibraryDescriptor.Dependency> getDependenciesWithPlugins(LibraryDescriptor descr, List<LibraryDescriptor> addPlugins) {
        List<LibraryDescriptor.Dependency> deps = descr.getDependencies();
        if (addPlugins == null) {
            return deps;
        }
        ArrayList<LibraryDescriptor.Dependency> newDeps = new ArrayList<LibraryDescriptor.Dependency>(deps.size() + addPlugins.size());
        newDeps.addAll(deps);
        for (LibraryDescriptor l : addPlugins) {
            newDeps.add(new LibraryDescriptor.Dependency.From(l));
        }
        return newDeps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDependenciesTreeForDependency(LibraryDescriptor descr, Tree.WithParent<LibraryDescriptorLoader.DependencyNode> tree, Map<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts, Collection<Pair<String, String>> exclusions, JoinPoint<NoException> jp, LibraryDescriptor.Dependency dep, WorkProgress progress, long step) {
        Tree.Node<LibraryDescriptorLoader.DependencyNode> n;
        LibraryDescriptorLoader.DependencyNode node = DynamicLibrariesManager.createDependencyNode(descr, dep);
        Tree.WithParent<LibraryDescriptorLoader.DependencyNode> withParent = tree;
        synchronized (withParent) {
            n = tree.add(node);
        }
        List<Tree.Node<LibraryDescriptorLoader.DependencyNode>> l = DynamicLibrariesManager.getDependenciesListFor(dep, n, artifacts);
        jp.addToJoin(1);
        node.getDescriptor().onDone(() -> {
            if (node.getDescriptor().getResult() != null) {
                HashSet<Pair<String, String>> excl = new HashSet<Pair<String, String>>();
                excl.addAll(exclusions);
                excl.addAll(dep.getExcludedDependencies());
                if (progress != null) {
                    progress.progress(step / 2L);
                }
                this.buildDependenciesTree(node.getDescriptor().getResult(), (Tree.WithParent)n.getSubNodes(), artifacts, excl, jp, null, progress, step - step / 2L);
            } else {
                if (progress != null) {
                    progress.progress(step);
                }
                if (dep.isOptional()) {
                    this.app.getDefaultLogger().debug("Dependency " + dep.getGroupId() + ':' + dep.getArtifactId() + ':' + dep.getVersionSpecification() + " not found, but optional");
                    Tree.WithParent withParent = tree;
                    synchronized (withParent) {
                        tree.removeInstance(node);
                    }
                    DynamicLibrariesManager.removeArtifact(l, n, dep, artifacts);
                }
            }
            jp.joined();
        });
    }

    private static boolean isMatching(String groupId, String artifactId, Collection<Pair<String, String>> list) {
        for (Pair<String, String> p : list) {
            if (p.getValue1() != null && !p.getValue1().equals(groupId) || p.getValue2() != null && !p.getValue2().equals(artifactId)) continue;
            return true;
        }
        return false;
    }

    private static LibraryDescriptorLoader.DependencyNode createDependencyNode(LibraryDescriptor descr, LibraryDescriptor.Dependency dep) {
        LibraryDescriptorLoader.DependencyNode node = new LibraryDescriptorLoader.DependencyNode(dep);
        if (dep.getGroupId() == null || dep.getGroupId().isEmpty()) {
            node.setDescriptor(new AsyncSupplier<Object, LibraryManagementException>(null, new LibraryManagementException("Missing groupId in dependency")));
        } else if (dep.getArtifactId() == null || dep.getArtifactId().isEmpty()) {
            node.setDescriptor(new AsyncSupplier<Object, LibraryManagementException>(null, new LibraryManagementException("Missing artifactId in dependency")));
        } else {
            VersionSpecification depV = dep.getVersionSpecification();
            if (depV == null) {
                node.setDescriptor(new AsyncSupplier<Object, LibraryManagementException>(null, new LibraryManagementException("Missing version in dependency")));
            } else {
                node.setDescriptor(descr.getLoader().loadLibrary(dep.getGroupId(), dep.getArtifactId(), depV, (byte)3, descr.getDependenciesAdditionalRepositories()));
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Tree.Node<LibraryDescriptorLoader.DependencyNode>> getDependenciesListFor(LibraryDescriptor.Dependency dep, Tree.Node<LibraryDescriptorLoader.DependencyNode> n, Map<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts) {
        Map<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> map = artifacts;
        synchronized (map) {
            List<Tree.Node<LibraryDescriptorLoader.DependencyNode>> list;
            Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> group = artifacts.get(dep.getGroupId());
            if (group == null) {
                group = new HashMap<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>();
                artifacts.put(dep.getGroupId(), group);
            }
            if ((list = group.get(dep.getArtifactId())) == null) {
                list = new LinkedList<Tree.Node<LibraryDescriptorLoader.DependencyNode>>();
                group.put(dep.getArtifactId(), list);
            }
            list.add(n);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeArtifact(List<Tree.Node<LibraryDescriptorLoader.DependencyNode>> list, Tree.Node<LibraryDescriptorLoader.DependencyNode> n, LibraryDescriptor.Dependency dep, Map<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts) {
        Map<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> map = artifacts;
        synchronized (map) {
            list.remove(n);
            if (list.isEmpty()) {
                Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> group = artifacts.get(dep.getGroupId());
                group.remove(dep.getArtifactId());
                if (group.isEmpty()) {
                    artifacts.remove(dep.getGroupId());
                }
            }
        }
    }

    @Override
    public IAsync<LibraryManagementException> onLibrariesLoaded() {
        return this.canStartApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<LoadedLibrary, LibraryManagementException> loadNewLibrary(final String groupId, final String artifactId, final VersionSpecification version, boolean optional, final byte priority, final WorkProgress progress, final long work) {
        Lib l;
        final String key = groupId + ':' + artifactId;
        Map<String, Lib> map = this.libraries;
        synchronized (map) {
            Lib lib = this.libraries.get(key);
            if (lib != null) {
                AsyncSupplier<LoadedLibrary, LibraryManagementException> result = new AsyncSupplier<LoadedLibrary, LibraryManagementException>();
                lib.load.onDone(() -> {
                    if (progress != null) {
                        progress.progress(work);
                    }
                    if (lib.load.hasError()) {
                        result.error((LibraryManagementException)lib.load.getError());
                    } else {
                        result.unblockSuccess(lib.library);
                    }
                });
                return result;
            }
            l = new Lib();
            this.libraries.put(key, l);
        }
        final MutableInteger loaderIndex = new MutableInteger(0);
        final AsyncSupplier<LoadedLibrary, LibraryManagementException> result = new AsyncSupplier<LoadedLibrary, LibraryManagementException>();
        Runnable nextLoader = new Runnable(){

            @Override
            public void run() {
                if (loaderIndex.get() == DynamicLibrariesManager.this.loaders.size()) {
                    if (progress != null) {
                        progress.progress(work);
                    }
                    LibraryManagementException error = new LibraryManagementException("Cannot find library " + key);
                    l.load.error(error);
                    result.error(error);
                    return;
                }
                AsyncSupplier<? extends LibraryDescriptor, LibraryManagementException> loadDescr = ((LibraryDescriptorLoader)DynamicLibrariesManager.this.loaders.get(loaderIndex.get())).loadLibrary(groupId, artifactId, version, priority, new ArrayList<LibrariesRepository>(0));
                3 next = this;
                loadDescr.onDone(() -> {
                    if (loadDescr.getResult() == null) {
                        loaderIndex.inc();
                        next.run();
                        return;
                    }
                    l.descr = (LibraryDescriptor)loadDescr.getResult();
                    Tree.WithParent tree = new Tree.WithParent(null);
                    HashMap artifacts = new HashMap();
                    JoinPoint treeDone = new JoinPoint();
                    ArrayList<Pair<String, String>> exclusions = new ArrayList<Pair<String, String>>(DynamicLibrariesManager.this.libraries.size());
                    for (Lib lib : DynamicLibrariesManager.this.libraries.values()) {
                        if (lib.descr == null) continue;
                        exclusions.add(new Pair<String, String>(lib.descr.getGroupId(), lib.descr.getArtifactId()));
                    }
                    DynamicLibrariesManager.this.buildDependenciesTree(l.descr, tree, artifacts, exclusions, treeDone, null, null, 0L);
                    treeDone.start();
                    ResolveVersionConflicts resolveConflicts = new ResolveVersionConflicts(artifacts, l.descr.getLoader(), null, 0L);
                    resolveConflicts.startOn(treeDone, true);
                    resolveConflicts.getOutput().onDone(() -> {
                        DynamicLibrariesManager.this.app.getDefaultLogger().debug("Dependencies analyzed, loading and initializing libraries");
                        LoadLibrary load = new LoadLibrary(l, (Map)resolveConflicts.getResult(), null, progress, work);
                        load.start();
                        l.load.onDone(result, () -> l.library);
                    }, result);
                });
            }
        };
        nextLoader.run();
        return result;
    }

    @Override
    public LoadedLibrary getLibrary(String groupId, String artifactId) {
        for (Lib lib : this.libraries.values()) {
            if (!lib.library.getGroupId().equals(groupId) || !lib.library.getArtifactId().equals(artifactId)) continue;
            return lib.library;
        }
        return null;
    }

    @Override
    public IO.Readable getResource(String groupId, String artifactId, String path, byte priority) {
        if (groupId != null && artifactId != null) {
            LoadedLibrary lib = this.getLibrary(groupId, artifactId);
            if (lib == null) {
                return null;
            }
            return this.getResourceFrom((ClassLoader)lib.getClassLoader(), path, priority);
        }
        return this.appClassLoader.getResourceIO(path, priority);
    }

    @Override
    public IO.Readable getResource(String path, byte priority) {
        return this.appClassLoader.getResourceIO(path, priority);
    }

    public IO.Readable getResourceFrom(ClassLoader cl, String path, byte priority) {
        IOProvider.Readable provider = new IOProviderFromPathUsingClassloader(cl).get(path);
        if (provider == null) {
            return null;
        }
        try {
            return provider.provideIOReadable(priority);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<File> getLibrariesLocations() {
        ArrayList<File> list = new ArrayList<File>(this.libraries.size());
        for (Lib lib : this.libraries.values()) {
            this.getLibrariesLocations(list, lib);
        }
        return list;
    }

    private void getLibrariesLocations(List<File> list, Lib lib) {
        File f;
        try {
            f = lib.descr.getClasses().blockResult(0L);
        }
        catch (Exception e) {
            return;
        }
        if (f == null) {
            return;
        }
        if (list.contains(f)) {
            return;
        }
        for (LibraryDescriptor.Dependency dep : lib.descr.getDependencies()) {
            String key = dep.getGroupId() + ':' + dep.getArtifactId();
            Lib depLib = this.libraries.get(key);
            if (depLib == null) continue;
            this.getLibrariesLocations(list, depLib);
        }
        list.add(f);
    }

    Task.Cpu<IAsync<Exception>, ApplicationBootstrapException> startApp() {
        Task.Cpu<IAsync<Exception>, ApplicationBootstrapException> task = new Task.Cpu<IAsync<Exception>, ApplicationBootstrapException>(this.app.getGroupId() + ':' + this.app.getArtifactId() + ':' + this.app.getVersion().toString(), 4){

            @Override
            public IAsync<Exception> run() throws ApplicationBootstrapException {
                ApplicationBootstrap startup;
                Class<?> cl;
                if (DynamicLibrariesManager.this.splash != null) {
                    DynamicLibrariesManager.this.splash.setText("Starting application " + DynamicLibrariesManager.this.appCfg.getName());
                }
                try {
                    cl = ((ClassLoader)DynamicLibrariesManager.this.appLib.library.getClassLoader()).loadClass(DynamicLibrariesManager.this.appCfg.getClazz());
                }
                catch (ClassNotFoundException e) {
                    throw new ApplicationBootstrapException("Application class does not exist", e);
                }
                if (!ApplicationBootstrap.class.isAssignableFrom(cl)) {
                    throw new ApplicationBootstrapException("Application class " + DynamicLibrariesManager.this.appCfg.getClazz() + " must implements ApplicationBootstrap");
                }
                try {
                    startup = (ApplicationBootstrap)cl.newInstance();
                }
                catch (Exception e) {
                    throw new ApplicationBootstrapException("Application class cannot be instantiated", e);
                }
                WorkProgress progress = DynamicLibrariesManager.this.splash != null ? DynamicLibrariesManager.this.splash : new FakeWorkProgress();
                IAsync<Exception> start = startup.start(DynamicLibrariesManager.this.app, progress);
                progress.getSynch().onDone(() -> DynamicLibrariesManager.this.splash = null);
                return start;
            }
        };
        task.start();
        return task;
    }

    @Override
    public void scanLibraries(String rootPackage, boolean includeSubPackages, Predicate<String> packageFilter, Predicate<String> classFilter, Consumer<Class<?>> classScanner) {
        this.appClassLoader.scanLibraries(rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
    }

    private class Init
    extends Task.Cpu<Void, NoException> {
        private Lib lib;
        private IAsync<Exception> previousStep;

        private Init(Lib lib) {
            super("Initialize library " + lib.descr.getGroupId() + ':' + lib.descr.getArtifactId(), (byte)2);
            this.previousStep = null;
            this.lib = lib;
        }

        @Override
        public Void run() {
            JoinPoint<LibraryManagementException> jp;
            if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                DynamicLibrariesManager.this.app.getDefaultLogger().debug("Initializing " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId() + ':' + this.lib.descr.getVersionString());
            }
            if (!this.loadExtensionPoints(jp = new JoinPoint<LibraryManagementException>())) {
                return null;
            }
            if (!this.loadCustomExtensionPoints(jp)) {
                return null;
            }
            if (!this.loadPlugins(jp)) {
                return null;
            }
            jp.start();
            jp.onDone(() -> {
                if (jp.hasError()) {
                    if (!this.lib.load.hasError()) {
                        this.lib.load.error(jp.getError());
                    }
                    return;
                }
                this.lib.load.unblock();
            });
            return null;
        }

        private boolean loadExtensionPoints(JoinPoint<LibraryManagementException> jp) {
            IO.Readable io;
            AsyncSupplier ep = null;
            try {
                io = ((AbstractClassLoader)this.lib.library.getClassLoader()).open("META-INF/net.lecousin/extensionpoints", (byte)2);
            }
            catch (FileNotFoundException e) {
                io = null;
            }
            catch (Exception t) {
                this.lib.load.error(new LibraryManagementException("Error reading file META-INF/net.lecousin/extensionpoints from library " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId(), t));
                return false;
            }
            if (io != null) {
                PreBufferedReadable bio = new PreBufferedReadable(io, 512, 2, 1024, 3, 8);
                BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream((IO.Readable)bio, StandardCharsets.UTF_8, 256, 32);
                ep = new LoadLibraryExtensionPointsFile(stream, this.lib.library.getClassLoader()).start();
                jp.addToJoin(ep, error -> new LibraryManagementException("Error loading extension points from " + this.lib, (Throwable)error));
                stream.closeAfter(ep);
                this.previousStep = ep;
            }
            return true;
        }

        private boolean loadCustomExtensionPoints(JoinPoint<LibraryManagementException> jp) {
            for (CustomExtensionPoint custom : ExtensionPoints.getCustomExtensionPoints()) {
                String path = custom.getPluginConfigurationFilePath();
                if (path == null) continue;
                IO.Readable io = null;
                try {
                    io = ((AbstractClassLoader)this.lib.library.getClassLoader()).open(path, (byte)2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception t) {
                    this.lib.load.error(new LibraryManagementException("Error reading file " + path + " from library " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId(), t));
                    return false;
                }
                if (io == null) continue;
                this.previousStep = custom.loadPluginConfiguration(io, this.lib.library.getClassLoader(), new IAsync[]{this.previousStep});
                jp.addToJoin(this.previousStep, error -> new LibraryManagementException("Error loading plugin from " + this.lib, (Throwable)error));
                io.closeAfter(this.previousStep);
            }
            return true;
        }

        private boolean loadPlugins(JoinPoint<LibraryManagementException> jp) {
            IO.Readable io = null;
            try {
                io = ((AbstractClassLoader)this.lib.library.getClassLoader()).open("META-INF/net.lecousin/plugins", (byte)2);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception t) {
                this.lib.load.error(new LibraryManagementException("Error reading file META-INF/net.lecousin/plugins from library " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId(), t));
                return false;
            }
            if (io != null) {
                PreBufferedReadable bio = new PreBufferedReadable(io, 512, 2, 1024, 3, 8);
                BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream((IO.Readable)bio, StandardCharsets.UTF_8, 256, 32);
                LoadLibraryPluginsFile task = new LoadLibraryPluginsFile(stream, this.lib.library.getClassLoader());
                Async sp = new Async();
                if (this.previousStep == null) {
                    task.start().onDone(sp);
                } else {
                    this.previousStep.onDone(() -> task.start().onDone(sp), sp);
                }
                jp.addToJoin(sp, error -> new LibraryManagementException("Error loading plugin from " + this.lib, (Throwable)error));
                io.closeAfter(sp);
            }
            return true;
        }
    }

    private class LoadLibrary
    extends Task.Cpu<Void, NoException> {
        private Lib lib;
        private Map<String, LibraryDescriptor> versions;
        private List<LibraryDescriptor> addPlugins;
        private WorkProgress progress;
        private long work;

        private LoadLibrary(Lib lib, Map<String, LibraryDescriptor> versions, List<LibraryDescriptor> addPlugins, WorkProgress progress, long work) {
            super("Load library " + lib.descr.getGroupId() + ':' + lib.descr.getArtifactId(), (byte)2);
            this.lib = lib;
            this.versions = versions;
            this.addPlugins = addPlugins;
            this.progress = progress;
            this.work = work;
        }

        @Override
        public Void run() {
            String key;
            if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                DynamicLibrariesManager.this.app.getDefaultLogger().debug("Loading " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId() + ':' + this.lib.descr.getVersionString());
            }
            JoinPoint<LibraryManagementException> jp = new JoinPoint<LibraryManagementException>();
            int nb = this.lib.descr.getDependencies().size() + (this.addPlugins != null ? this.addPlugins.size() : 0);
            for (LibraryDescriptor.Dependency dep : this.lib.descr.getDependencies()) {
                key = dep.getGroupId() + ':' + dep.getArtifactId();
                LibraryDescriptor d = this.versions.get(key);
                long step = this.work / (long)nb--;
                if (d == null) continue;
                this.work -= step;
                this.load(d, key, jp, step);
            }
            if (this.addPlugins != null) {
                for (LibraryDescriptor d : this.addPlugins) {
                    key = d.getGroupId() + ':' + d.getArtifactId();
                    long step = this.work / (long)nb--;
                    this.work -= step;
                    this.load(d, key, jp, step);
                }
            }
            jp.start();
            if (this.work > 0L && this.progress != null) {
                this.progress.progress(this.work);
            }
            this.lib.descr.getClasses().onDone(file -> {
                if (file != null) {
                    if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                        DynamicLibrariesManager.this.app.getDefaultLogger().debug(this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId() + ':' + this.lib.descr.getVersionString() + " loaded from " + file.getAbsolutePath());
                    }
                    this.lib.library = new LoadedLibrary(new Artifact(this.lib.descr.getGroupId(), this.lib.descr.getArtifactId(), this.lib.descr.getVersion()), DynamicLibrariesManager.this.appClassLoader.add((File)file, null));
                    jp.thenStart(new Init(this.lib), this.lib.load);
                } else {
                    if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                        DynamicLibrariesManager.this.app.getDefaultLogger().debug("No classes in " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId() + ':' + this.lib.descr.getVersionString());
                    }
                    this.lib.library = new LoadedLibrary(new Artifact(this.lib.descr.getGroupId(), this.lib.descr.getArtifactId(), this.lib.descr.getVersion()), null);
                    jp.onDone(this.lib.load);
                }
            });
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load(LibraryDescriptor d, String key, JoinPoint<LibraryManagementException> jp, long work) {
            Lib l;
            Map map = DynamicLibrariesManager.this.libraries;
            synchronized (map) {
                l = (Lib)DynamicLibrariesManager.this.libraries.get(key);
                if (l != null) {
                    jp.addToJoin(l.load);
                    if (this.progress != null) {
                        l.load.onDone(() -> this.progress.progress(work));
                    }
                    return;
                }
                l = new Lib();
                l.descr = d;
                DynamicLibrariesManager.this.libraries.put(key, l);
            }
            new LoadLibrary(l, this.versions, null, this.progress, work).start();
            jp.addToJoin(l.load);
        }
    }

    private class ResolveVersionConflicts
    extends Task.Cpu<Map<String, LibraryDescriptor>, LibraryManagementException> {
        private Map<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts;
        private LibraryDescriptorLoader resolver;
        private WorkProgress progress;
        private long work;

        private ResolveVersionConflicts(Map<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts, LibraryDescriptorLoader resolver, WorkProgress progress, long work) {
            super("Resolve library version conflicts", (byte)2);
            this.artifacts = artifacts;
            this.resolver = resolver;
            this.progress = progress;
            this.work = work;
        }

        @Override
        public Map<String, LibraryDescriptor> run() throws LibraryManagementException {
            if (this.progress != null) {
                this.progress.setText("Resolving dependencies versions");
            }
            DynamicLibrariesManager.this.app.getDefaultLogger().debug("Resolving version conflicts");
            HashMap<String, LibraryDescriptor> versions = new HashMap<String, LibraryDescriptor>();
            for (Map.Entry<String, Map<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>> group : this.artifacts.entrySet()) {
                for (Map.Entry<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> artifact : group.getValue().entrySet()) {
                    Version version;
                    Map<Version, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> artifactVersions = this.getArtifactVersions(artifact);
                    if (artifactVersions.isEmpty()) {
                        throw new LibraryManagementException("Unable to load library " + group.getKey() + ':' + artifact.getKey());
                    }
                    if (artifactVersions.size() == 1) {
                        version = artifactVersions.keySet().iterator().next();
                        versions.put(group.getKey() + ':' + artifact.getKey(), artifactVersions.get(version).get(0).getElement().getDescriptor().getResult());
                        continue;
                    }
                    version = this.resolver.resolveVersionConflict(group.getKey(), artifact.getKey(), artifactVersions);
                    if (version == null) {
                        throw new LibraryManagementException("Unable to resolve version conflict for library " + group.getKey() + ':' + artifact.getKey());
                    }
                    if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                        DynamicLibrariesManager.this.app.getDefaultLogger().debug("Version conflict for " + group.getKey() + ':' + artifact.getKey() + " resolved to " + artifactVersions.get(version).get(0).getElement().getDescriptor().getResult().getVersionString());
                    }
                    versions.put(group.getKey() + ':' + artifact.getKey(), artifactVersions.get(version).get(0).getElement().getDescriptor().getResult());
                }
            }
            if (this.progress != null) {
                this.progress.progress(this.work);
            }
            return versions;
        }

        private Map<Version, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> getArtifactVersions(Map.Entry<String, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> artifact) {
            HashMap<Version, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>> artifactVersions = new HashMap<Version, List<Tree.Node<LibraryDescriptorLoader.DependencyNode>>>();
            for (Tree.Node<LibraryDescriptorLoader.DependencyNode> node : artifact.getValue()) {
                if (node.getElement().getDescriptor().hasError()) {
                    DynamicLibrariesManager.this.app.getDefaultLogger().error("Dependency ignored: " + node.getElement().getDependency().getGroupId() + ':' + node.getElement().getDependency().getArtifactId() + " because of loading error", node.getElement().getDescriptor().getError());
                    continue;
                }
                Version version = node.getElement().getDescriptor().getResult().getVersion();
                LinkedList<Tree.Node<LibraryDescriptorLoader.DependencyNode>> nodes = (LinkedList<Tree.Node<LibraryDescriptorLoader.DependencyNode>>)artifactVersions.get(version);
                if (nodes == null) {
                    nodes = new LinkedList<Tree.Node<LibraryDescriptorLoader.DependencyNode>>();
                    artifactVersions.put(version, nodes);
                }
                nodes.add(node);
            }
            return artifactVersions;
        }
    }

    private static class Lib {
        private LibraryDescriptor descr;
        private Async<LibraryManagementException> load = new Async();
        private LoadedLibrary library;

        private Lib() {
        }
    }
}

